﻿using UnityEngine;

namespace cn.m4399.operateBz
{
    public class UnityAndroid
    {
        public static AndroidJavaObject GetUnityActivity()
        {
            using (var unityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer"))
            {
                return unityPlayer.GetStatic<AndroidJavaObject>("currentActivity");
            }
        }

        public static void RunOnUiThread(AndroidJavaRunnable androidJavaRunnable)
        {
            GetUnityActivity().Call("runOnUiThread", androidJavaRunnable);
        }

        public static void Toast(string msg)
        {
            RunOnUiThread(new AndroidJavaRunnable(() =>
            {
                using (AndroidJavaClass toastClass = new AndroidJavaClass("android.widget.Toast"))
                {
                    using (AndroidJavaObject tastObject = toastClass.CallStatic<AndroidJavaObject>("makeText", GetUnityActivity(), msg, 0))
                    {
                        tastObject.Call("show");
                    }
                }
            }));
        }

        public static AndroidJavaObject GetApplication()
        {
            return GetUnityActivity().Call<AndroidJavaObject>("getApplication");
        }
    }
}
