﻿using UnityEngine;

namespace cn.m4399.operateBz
{
    public class Order
    {
        private AndroidJavaObject JavaObject;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="money"></param>
        /// <param name="mark"></param>
        public Order(int money, string mark)
        {
            JavaObject = new AndroidJavaObject("cn.m4399.operateBZ.Order", money, mark);
        }

        /// <summary>
        /// 设置商品名称，可选接口
        /// </summary>
        /// <param name="commodity"></param>
        /// <returns></returns>
        public Order Commodity(string commodity)
        {
            JavaObject.Call<AndroidJavaObject>("commodity", commodity);
            return this;
        }

        /// <summary>
        /// 设置是否支持超出金额
        /// </summary>
        /// <param name="support"></param>
        /// <returns></returns>
        public Order SupportExcess(bool support)
        {
            JavaObject.Call<AndroidJavaObject>("supportExcess", support);
            return this;
        }

        /// <summary>
        ///  设置透传字段，可选接口
        /// </summary>
        /// <param name="passthrough"></param>
        /// <returns></returns>
        public Order Passthrough(string passthrough)
        {
            JavaObject.Call<AndroidJavaObject>("passthrough", passthrough);
            return this;
        }

        internal AndroidJavaObject GetJavaObject()
        {
            return JavaObject;
        }
    }
}
