﻿using UnityEngine;

namespace cn.m4399.operateBz
{
    public class OperateConfig
    {
        private readonly AndroidJavaObject JavaObejct;

        private OperateConfig(AndroidJavaObject javaObject)
        {
            JavaObejct = javaObject;
        }

        internal AndroidJavaObject GetJavaObject()
        {
            return JavaObejct;
        }

        public class Builder
        {
            private readonly AndroidJavaObject JavaObejct;

            public Builder()
            {
                JavaObejct = new AndroidJavaObject("cn.m4399.operateBZ.OperateConfig$Builder", UnityAndroid.GetUnityActivity());
            }

            public Builder SetGameKey(string gameKey)
            {
                JavaObejct.Call<AndroidJavaObject>("setGameKey", gameKey);
                return this;
            }

            public Builder SetDebugEnabled(bool enabled)
            {
                JavaObejct.Call<AndroidJavaObject>("setDebugEnabled", enabled);
                return this;
            }

            public Builder SetOrientation(int orientation)
            {
                JavaObejct.Call<AndroidJavaObject>("setOrientation", orientation);
                return this;
            }

            public Builder CompatNotch(bool b)
            {
                JavaObejct.Call<AndroidJavaObject>("compatNotch", b);
                return this;
            }

            public OperateConfig Build()
            {
                var javaObject = JavaObejct.Call<AndroidJavaObject>("build");
                return new OperateConfig(javaObject);
            }
        }
    }

}
