﻿using UnityEngine;
using UnityEngine.UI;
using UnityEngine.Android;
using UnityEngine.SceneManagement;
using cn.m4399.operateBz;
using static cn.m4399.operateBz.OperateCenter;
using static cn.m4399.operateBz.CloudArchive;

public class OperateBzDemo : MonoBehaviour
{
    private const string TAG = "【OperateBzDemo】";

    private const string GAME_KEY = "40027";

    private static bool InitedSDK = false;

    private OperateCenter Ope;

    private static OperateConfig OpeConfig;

    private bool RequestedPermission = false;//请求过权限，但是用户不一定有授权

    private void Awake()
    {
        GameObject.Find("BtnLogin").GetComponent<Button>().onClick.AddListener(DoLogin);
        GameObject.Find("BtnRecharge").GetComponent<Button>().onClick.AddListener(DoRecharge);
        GameObject.Find("BtnReadArchive").GetComponent<Button>().onClick.AddListener(DoCloudArchiveGet);
        GameObject.Find("BtnSaveArchive").GetComponent<Button>().onClick.AddListener(DoCloudArchiveSet);
        GameObject.Find("BtnGetCurrentAccount").GetComponent<Button>().onClick.AddListener(DoGetCurrentAccount);
        GameObject.Find("BtnIsLogin").GetComponent<Button>().onClick.AddListener(DoIsLogin);
        GameObject.Find("BtnExit").GetComponent<Button>().onClick.AddListener(DoLogout);
        GameObject.Find("BtnGetVersion").GetComponent<Button>().onClick.AddListener(DoGetVersion);
        InitSDK();
    }

    private void OnApplicationFocus(bool focus)
    {
        //如果您的Unity版本支持Android.PermissionCallbacks，则不需要这种方式
        if (focus && !InitedSDK)
        {
            InitSDK();
        }
    }

    //检测空格
    private bool IsSpace(string textValue)
    {
        if (textValue.Trim().Length == 0)//去掉字符串头尾的空格
        {
            return true;
        }
        return false;
    }

    private void InitSDK()
    {
        Ope = OperateCenter.GetInstance();
        var operateConfig = new OperateConfig.Builder()
                .SetGameKey(GAME_KEY)
                .SetDebugEnabled(false)
                .SetOrientation(0)
                .CompatNotch(true)
                .Build();
        Ope.SetConfig(operateConfig);
        Ope.Init(new OnInitGlobalListenerImpl());
    }

    private void DoGetVersion()
    {
        var version = OperateCenter.GetVersion();
        ToastAndLog($"version:{version}");
    }

    private void DoLogin()
    {
        Ope.Login(new OnLoginFinishedListenerImpl());
    }

    private void DoRecharge()
    {
        string ip_money = GameObject.Find("IpMoney").GetComponent<InputField>().text;
        int money = 1;
        if (!IsSpace(ip_money))
        {
            money = int.Parse(ip_money);
        }
        string mark = "123456789";
        string commodity = "test";
        var order = new Order(money, mark).Commodity(commodity);
        Ope.Recharge(order, new OnRechargeFinishedListenerImpl());
    }

        

    public void DoCloudArchiveGet()
    {
        Ope.GetArchiveStringSimple(new OnSimpleStrGetListenerImpl());
    }

    public void DoCloudArchiveSet()
    {
        string ip_archive = GameObject.Find("IpArchiveData").GetComponent<InputField>().text;
        if (IsSpace(ip_archive))
        {
            ip_archive = "test Data";
        }
        Ope.SetArchiveStringSimple(ip_archive, new OnSimpleStrSetListenerImpl());
    }

    public void DoGetCurrentAccount()
    {
        var user = Ope.GetCurrentAccount();
        ToastAndLog($"user:{user}");
    }

    public void DoIsLogin()
    {
        var isLogin = Ope.IsLogin();
        ToastAndLog($"isLogin:{isLogin}");
    }

    private void DoLogout()
    {
        Ope.Logout();
    }

    class OnInitGlobalListenerImpl : OnInitGlobalListener
    {
        protected override void OnInitFinished(bool isLogin, User user)
        {
            ToastAndLog($"OnInitFinished isLogin:{isLogin} user:{user}");
            InitedSDK = true;
        }

        protected override void OnSwitchUserAccountFinished(bool fromUserCenter, User user)
        {
            //弃用，无需处理
        }

        protected override void OnUserAccountLogout(bool fromUserCenter)
        {
            ToastAndLog($"OnUserAccountLogout fromUserCenter:{fromUserCenter}");
        }
    }

    class OnLoginFinishedListenerImpl : OnLoginFinishedListener
    {
        protected override void OnLoginFinished(bool success, int resultCode, User user)
        {
            ToastAndLog($"OnLoginFinished success:{success} resultCode:{resultCode} user:{user}");
        }
    }

    class OnRechargeFinishedListenerImpl : OnRechargeFinishedListener
    {
        protected override void OnRechargeFinished(bool success, int resultCode, string msg)
        {
            ToastAndLog($"OnRechargeFinished success:{success} resultCode:{resultCode} msg:{msg}");
        }
    }

    class OnSimpleStrGetListenerImpl : OnSimpleStrGetListener
    {
        protected override void OnSuccess(string arch)
        {
            ToastAndLog($"OnSuccess arch:{arch}");
        }

        protected override void OnFailure(int resultCode, string msg)
        {
            ToastAndLog($"OnFailure resultCode:{resultCode} msg:{msg}");
        }
    }

    class OnSimpleStrSetListenerImpl : OnSimpleStrSetListener
    {
        protected override void OnSuccess()
        {
            ToastAndLog($"OnSuccess");
        }

        protected override void OnFailure(int resultCode, string msg)
        {
            ToastAndLog($"OnFailure resultCode:{resultCode} msg:{msg}");
        }
    }

    static void ToastAndLog(string s)
    {
        DemoCommons.ToastAndLog(TAG, s);
    }
}
