﻿using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using UnityEditor.Android;
using UnityEngine;

namespace cn.m4399.sdk
{
    /// <summary>
    /// 将AndroidManifest.xml中的Activity launchMode 修改为android:launchMode="singleTop"
    /// 4399 sdk
    /// </summary>
    public abstract class AndroidManifestLaunchModeSingleTop : IPostGenerateGradleAndroidProject
    {
        /// <summary>
        /// 顺序
        /// </summary>
        public virtual int callbackOrder => 4399;


        /// <summary>
        /// 子类复写这个方法返回需要修改的Activity的类名
        /// 例如:com.unity3d.player.UnityPlayerActivity
        /// </summary>
        /// <returns></returns>
        public abstract string ActivityClass();

        public void OnPostGenerateGradleAndroidProject(string path)
        {
            var activityClass = ActivityClass();
            var androidManifestPath = $"{path}/src/main/AndroidManifest.xml";//AndroidManifest.xml的路径
            Debug.Log($"androidManifestPath:{androidManifestPath}");
            var androidManifestSourceText = File.ReadAllText(androidManifestPath);//读取AndroidManifest.xml内容
            var scopeRegex = new Regex($"<activity[^>]+?android:name\\s*=\\s*\"{activityClass}\"[^>]*");//定位
            var scopeMatch = scopeRegex.Match(androidManifestSourceText);
            var stringBuilder = new StringBuilder();
            if (scopeMatch.Success)
            {
                if (scopeMatch.Index > 0)
                {
                    stringBuilder.Append(androidManifestSourceText.Substring(0, scopeMatch.Index));
                }
                var launchModeRegex = new Regex("android:launchMode\\s*=\\s*\"[^\"]*\"");
                string replacedScope;
                if (launchModeRegex.Match(scopeMatch.Value).Success)
                {
                    replacedScope = launchModeRegex.Replace(scopeMatch.Value, "android:launchMode=\"singleTop\"");
                }
                else
                {
                    replacedScope = scopeMatch.Value + " android:launchMode=\"singleTop\"";
                }
                stringBuilder.Append(replacedScope);
                if (scopeMatch.Index + scopeMatch.Length < androidManifestSourceText.Length)
                {
                    stringBuilder.Append(androidManifestSourceText.Substring(scopeMatch.Index + scopeMatch.Length));
                }
            }
            else
            {
                throw new System.Exception($"找不到Activity:{activityClass}");
            }
            var androidManifestText = stringBuilder.ToString();
            File.WriteAllText(androidManifestPath, androidManifestText);//写回AndroidManifest.xml    
        }
    }
}