package cn.m4399.rpgsample;

import android.app.Activity;
import android.text.TextUtils;

import com.example.rpgsample.R;

import cn.m4399.operateBZ.OperateCenter;
import cn.m4399.operateBZ.Order;

class RechargeHelper {
    private final static int MARK_MAX_LENGTH = 32;

    public void recharge(Activity activity, String value, String mark, String commodity,
                         OperateCenter.OnRechargeFinishedListener listener) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                int money = 6;
                if (!TextUtils.isEmpty(value) && Integer.parseInt(value) > 0) {
                    money = Integer.parseInt(value);
                }
                // C：充值
                String markId = mark;
                if (TextUtils.isEmpty(markId)) {
                    markId = createUniqueMark();
                }
                String commodityName = commodity;
                if (TextUtils.isEmpty(commodityName)) {
                    commodityName = activity.getString(R.string.m4399_ope_bz_recharge_good_commodity, money);
                }
                OperateCenter.getInstance().recharge(activity,
                        // 充值金额，整数，单位元
                        new Order(money, markId)
                                // 是否支持超出金额，默认不支持
                                .supportExcess(false)
                                // 商品名，可选，不传时认为商品名是游戏币
                                .commodity(commodityName),
                        listener);
            }
        });
    }

    private String createUniqueMark() {
        // 生成mark示例, 支持字母、数字和字符‘-’，‘_’，‘|’，最长32位
        // 参考格式：商品id|用户id-区服id_时间戳
        String mark = "cid|uid-sid_" + System.currentTimeMillis();
        if (mark.length() > MARK_MAX_LENGTH)
            mark = mark.substring(0, MARK_MAX_LENGTH);
        return mark;
    }
}
