package com.operatebz.js.demo

import android.annotation.SuppressLint
import android.app.Activity
import android.os.Bundle
import android.webkit.WebSettings
import android.webkit.WebView
import android.webkit.WebViewClient
import com.operatebz.js.OperateBZJsApi


class GameActivity : Activity() {

  private lateinit var mWebView: WebView
  private val mGameUrl: String = "file:///android_asset/index.html"

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    setContentView(R.layout.game_activity)
    loadGame()
  }

  @SuppressLint("JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled")
  private fun loadGame() {
    mWebView = findViewById(R.id.web_game)
    val webSettings: WebSettings = mWebView.settings
    webSettings.javaScriptEnabled = true
    webSettings.domStorageEnabled = true
    mWebView.webViewClient = WebViewClient()
    // 'operateBZNativeApi' 即为注入到浏览器中的对象名称，用它间接调用 java 本地方法
    mWebView.addJavascriptInterface(OperateBZJsApi(this, mWebView), "operateBZNativeApi")
    
    mWebView.loadUrl(mGameUrl)
  }
}