const _TAG = "[OPERATE-BZ-JS]";

function log(method, objects) {
    var output = method + "(";
    var i = 0;
    if (objects instanceof Array) {
        objects.forEach(function (o) {
            if (i !== 0)
                output += ', ' + o;
            else {
                output += o;
                i++;
            }
        })
    }
    output += ");"
    console.log(output);
}

const operateBZJsApi = {
    // [gameId] 游戏game id
    // [cb] 回调接口，原型：function(code, message)，code 为0时成功
    testMethod: function (gameId, cb) {
        const cbName = "initCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        operateBZNativeApi.testMethod(gameId, cbName);
        log('operateBZNativeApi.testMethod', [gameId, cbName]);
    },
    
    // 初始化sdk
    //
    // SDK 初始化，是初始化内部环境，为调用其他接口做准备；初始化也进行版本更新、游戏维护、登录状态等检查
    // 注意：初始化接口的调用一般是应用启动的时候自动调用，一次成功即可，无需手动频繁调用！
    //
    // [gameId] 游戏game id
    // [screenOrientation] SDK 页面方向，支持横屏或竖屏，但不支持横竖屏切换,
    //    数字，值为 0 表示横屏，其他值有 0:横屏 | 1:竖屏 | 6:可180度旋转
    // [compatNotch] 是否兼容全面屏，一般为 true
    // [cb] 回调接口，原型：function(code, message)，code 为0时成功
    init: function (gameId, screenOrientation, compatNotch, cb) {
        const cbName = "initCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        const logoutCbName = "logoutCallback";
        window[logoutCbName] = function (code, message) {
            cb(code, message);
        }        
        operateBZNativeApi.initSDK(gameId, screenOrientation, compatNotch, cbName, logoutCbName);
        log(`operateBZNativeApi.initSDK(${gameId}, ${screenOrientation}, ${compatNotch}, ${cbName}, ${logoutCbName});`);
    },
    
    // 登录
    //
    // 需要登录时调用此接口，一般是在游戏启动页面上调用，调用此接口需要先完成sdk初始化
    //
    // [cb] 回调接口，原型：function(code, message，user)，code 为0时成功，user为json字符串，更多说明见文档
    login: function (cb) {
        const cbName = "loginCallback";
        window[cbName] = function (code, message, user) {
            cb(code, message, JSON.parse(user));
        }
        operateBZNativeApi.login(cbName);
        log(`operateBZNativeApi.login(${cbName});`)
    },
    
    // 查询是否有已登录账号
    //
    // 查询 SDK 内部是否已有登录状态，一般用在初始化结束后或登录前判断是否已有登录状态
    // 返回值为布尔型，true为已登陆，false为未登录
    isLogin: function () {
        log(`operateBZNativeApi.isLogin();`);
        return operateBZNativeApi.isLogin();
    }, 
    
    // 获取当前登录的账号信息
    //
    // 在 SDK 处于登录状态时，可通过该接口获取当前用户的信息，
    // 初始化后，先“查询是否有已登录账号”，若有登录，可通过此接口获取登录信息
    //
    // 已登录返回正常的 user 信息，user 说明见文档；否则 user 各字段都为空
    getUser: function () {
        log(`operateBZNativeApi.getUser();`);
        return operateBZNativeApi.getUser();
    },    
    
    // 账号登出
    //
    // 当需要登出账号时调用，SDK 立即清除本地用户状态
    logout: function () {
        operateBZNativeApi.logout();
        log('operateBZNativeApi.logout');
    },   
    
    // 获取sdk版本号
    //
    getSdkVersion: function () {
        return operateBZNativeApi.getSdkVersion();
        log('operateBZNativeApi.getSdkVersion');
    }, 
    
    // 客户端充值接口
    //
    // 游戏调用此接口打开充值界面，完成支付流程，SDK 支持在微信、支付宝等 APP 内完成支付
    // 注意：充值接口接入前需完成“充值回调”的接入，具体可咨询运营人员
    //
    // 参数：
    // [money] 充值金额，整型，单位元
    // [mark] 游戏订单，字符串，支持字母、数字和字符‘-’，‘_’，‘|’，非空、唯一
    // [commodity] 商品名称，必须，最长 32 个中文字符长度
    // [cb] 回调接口，原型：function(code, message)，code 为0时成功，其他情况见文档
    recharge: function (money, mark, commodity, cb) {
        const cbName = "rechargeCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }

        operateBZNativeApi.recharge(money, mark, commodity, cbName);
        log('operateBZNativeApi.recharge', [money, mark, commodity, cbName]);
    },
    
    // 云存档上传
    //
    // 游戏调用此接口上传存档数据，与当前登录账号绑定
    //
    // 参数：
    // [archive] 存档数据，字符串
    setArchive: function (archive, cb) {
        const cbName = "setArchiveCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }

        operateBZNativeApi.setArchive(archive, cbName);
        log('operateBZNativeApi.setArchive', [archive, cbName]);
    },
    
    // 获取存档
    //
    getArchive: function (cb) {
        const cbName = "getArchiveCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        operateBZNativeApi.getArchive(cbName);
        log('operateBZNativeApi.getArchive');
    },     
}

// 模拟对象
const mockOperateBZJsApi = {
    testMethod: function (gameId, cb) {
        const cbName = "initCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        log('gameNativeApi.initSDK', [gameId, cbName]);
        cb(0, "模拟初始化成功");
    },
    
    init: function (gameId, screenOrientation, compatNotch, cb) {
        const cbName = "initCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        const logoutCbName = "logoutCallback";
        window[logoutCbName] = function (code, message) {
            cb(code, message);
        }        
        
        log(`operateBZNativeApi.initSDK(${gameId}, ${screenOrientation}, ${compatNotch}, ${cbName}, ${logoutCbName});`);
        cb(0, "模拟初始化成功");
    },
    
    login: function (cb) {
        const cbName = "loginCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        log('gameNativeApi.login', [cbName]);
        cb(0, "模拟登录成功");
    },
    
    logout: function () {
        log('gameNativeApi.logout');
    },
    
    recharge: function (money, mark, commodity, cb) {
        const cbName = "rechargeCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        log('gameNativeApi.recharge', [cbName]);
        cb(0, "模拟充值成功");
    },
    
    setArchive: function (archive, cb) {
        const cbName = "setArchiveCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        log('gameNativeApi.setArchive', [cbName]);
        cb(0, "模拟上传存档成功");
    },
    
    getArchive: function (cb) {
        const cbName = "getArchiveCallback";
        window[cbName] = function (code, message) {
            cb(code, message);
        }
        log('gameNativeApi.getArchive', [cbName]);
        cb(0, "模拟获取存档成功");
    },
    
    isLogin: function () {
        log('gameNativeApi.isLogin');
        return true;
    }, 
    
    getSdkVersion: function () {
        log('operateBZNativeApi.getSdkVersion');
        return 'test1.0.0';
    }, 
    
    getUser: function () {
        log(`operateBZNativeApi.getUser()`);
        return '{"name":"testUser","uid":"1","state":"1","phone":"","idCardState":-1,"nick":""}';
    },  
}

if (!window.operateBZNativeApi) // 否则使用模拟对象
    window.operateBZJs = mockOperateBZJsApi;
else // android 环境中使用真实对象
    window.operateBZJs = operateBZJsApi;