import java.util.Properties

plugins {
  id("com.android.application")
  id("org.jetbrains.kotlin.android")
}

val tauriProperties = Properties().apply {
  val propFile = file("tauri.properties")
  if (propFile.exists()) {
    propFile.inputStream().use { load(it) }
  }
}

android {
  //noinspection GradleDependency
  compileSdk = 33
  namespace = "dev.nzu.h5game"
  defaultConfig {
    manifestPlaceholders["usesCleartextTraffic"] = "true"
    applicationId = "dev.nzu.h5game"
    minSdk = 24
    //noinspection GradleDependency
    targetSdk = 33
    versionCode = tauriProperties.getProperty("tauri.android.versionCode", "1").toInt()
    versionName = tauriProperties.getProperty("tauri.android.versionName", "1.0")
  }
  buildTypes {
    getByName("debug") {
      manifestPlaceholders["usesCleartextTraffic"] = "true"
      isDebuggable = true
      isJniDebuggable = true
      isMinifyEnabled = false
      packaging {
        jniLibs.keepDebugSymbols.add("*/arm64-v8a/*.so")
        jniLibs.keepDebugSymbols.add("*/armeabi-v7a/*.so")
        jniLibs.keepDebugSymbols.add("*/x86/*.so")
        jniLibs.keepDebugSymbols.add("*/x86_64/*.so")
      }
    }
    getByName("release") {
      isMinifyEnabled = true
      proguardFiles(
        *fileTree(".") { include("**/*.pro") }
          .plus(getDefaultProguardFile("proguard-android-optimize.txt"))
          .toList().toTypedArray()
      )
    }
  }
  kotlinOptions {
    jvmTarget = "1.8"
  }
  buildFeatures {
    buildConfig = true
  }
}

dependencies {
  implementation(project(":operateBZjs"))
  implementation("androidx.webkit:webkit:1.6.1")
  implementation("androidx.appcompat:appcompat:1.6.1")
  implementation("com.google.android.material:material:1.8.0")
}

apply(from = "tauri.build.gradle.kts")