package cn.m4399.operateBZ.samples;

import static cn.m4399.operateBZ.samples.GameSettings.COMPACT_NOTCH;
import static cn.m4399.operateBZ.samples.GameSettings.SCREEN_ORIENTATION;
import static cn.m4399.operateBZ.samples.GameSettings.SUPPORT_EXCESS;
import static cn.m4399.operateBZ.samples.GameSettings.createUniqueMark;

import android.content.ContentResolver;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import android.widget.Toast;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

import cn.m4399.operateBZ.CloudArchive;
import cn.m4399.operateBZ.OperateCenter;
import cn.m4399.operateBZ.OperateConfig;
import cn.m4399.operateBZ.Order;
import cn.m4399.operateBZ.User;

public class OnlineGameActivity extends FragmentActivity {
    public static final String TAG = "【DEMO】";
    private static final String GAME_KEY = "40027";
    private OperateCenter mOpeCenter;
    public TextView mArchiveText;
    public TextView mETArchive;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setRequestedOrientation(SCREEN_ORIENTATION);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P && COMPACT_NOTCH)
            GameSettings.compactNotch(this);

        setContentView(R.layout.online_game_activity);
        showSDKVersion();

        initSDK();
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        setContentView(R.layout.online_game_activity);
        showSDKVersion();
    }

    public void doGetArchive() {
        OperateCenter.getInstance().getArchiveStringSimple(new CloudArchive.SimpleStrGetListener() {
            @Override
            public void onSuccess(@NonNull String archive) {
                toastAndLog(getString(R.string.m4399_ope_bz_archive_get_success));
                setArchiveStr(archive);
            }

            @Override
            public void onFailure(int code, @NonNull String message) {
                toastAndLog(getString(R.string.m4399_ope_bz_archive_get_failed_tip));
                setArchiveStr(getString(R.string.m4399_ope_bz_archive_get_failed_tip));
            }
        });
    }

    public void onSaveArchive(String archiveStr) {
        if (TextUtils.isEmpty(archiveStr)) {
            toastAndLog(getString(cn.m4399.operateBZ.R.string.m4399_cloud_archive_archive_data_cannot_be_empty));
            return;
        }

        OperateCenter.getInstance().setArchiveStringSimple(archiveStr, new CloudArchive.SimpleStrSetListener() {
            @Override
            public void onSuccess() {
                toastAndLog(getString(R.string.m4399_ope_bz_archive_set_success));
            }

            @Override
            public void onFailure(int code, @NonNull String message) {
                toastAndLog(getString(R.string.m4399_ope_bz_archive_set_failed_tip) + "：" + message);
            }
        });
    }

    public void setArchiveStr(String text) {
        mArchiveText.setText(text);
    }

    private void showSDKVersion() {
        TextView textView = findViewById(R.id.text_version);
        textView.setText(getString(R.string.demo_and_sdk_info, OperateCenter.getVersion(), GAME_KEY));
        mArchiveText = findViewById(R.id.tv_archive);
        mETArchive = findViewById(R.id.et_demo_archive_data);
    }

    private void initSDK() {
        mOpeCenter = OperateCenter.getInstance();

        // 初始化选项，传入游戏配置，更多说明见接入文档
        OperateConfig config = new OperateConfig.Builder(this)
                // 设置调试模式，可选，true时打开，默认false,发布前必须设置为false或删除该行
                .setDebugEnabled(false)
                // 设置游戏运营 key，此参数需要在原创开放平台注册应用后得到
                .setGameKey(GAME_KEY)
                // 设置SDK页面方向，应与游戏方向一致，部分第三方页面需要在AndroidManifest中设置
                .setOrientation(SCREEN_ORIENTATION)
                // 设置游戏充值是否支持超出金额，true时支持，默认true
                // 也可以每次充值通过 OperateCenter.setSupportExcess 设置
                .setSupportExcess(SUPPORT_EXCESS)
                // 设置游戏是否兼在高于Android 9.0版本系统容全面屏，默认不兼容
                .compatNotch(COMPACT_NOTCH)
                .build();
        mOpeCenter.setConfig(config);

        // A1: 初始化SDK
        // 此过程中检查当前帐号是否在登录中，只有在init之后， isLogin()返回的状态才可靠
        // 注意：初始化完成后，其他接口才可用
        mOpeCenter.init(OnlineGameActivity.this, new OperateCenter.OnInitGlobalListener() {
            // 执行化结果处理
            @Override
            public void onInitFinished(boolean isLogin, User user) {
                String state = isLogin ? getString(R.string.login_already) : getString(R.string.login_not_yet);
                toastAndLog(getString(R.string.init_result, state, user.toString()));
                if (isLogin) {
                    doGetArchive();
                } else {
                    setArchiveStr(getString(R.string.m4399_ope_bz_cloud_archive_not_logged_in));
                }
            }

            /*
             * 注销帐号的回调，游戏一般应在此回到登录场景
             * fromUserCenter 区分是否是从悬浮窗-个人中心("4399游戏助手页面")注销的，若是则为true，不是为false
             */
            @Override
            public void onUserAccountLogout(boolean fromUserCenter) {
                toastAndLog(getString(fromUserCenter ? R.string.logout_from_user_center : R.string.logout_not_from_user_center));
                setArchiveStr(getString(R.string.m4399_ope_bz_cloud_archive_not_logged_in));
            }

            // 个人中心里切换帐号的回调，游戏一般应在此回到选服场景（分区服），或者其他初始场景
            @Override
            public void onSwitchUserAccountFinished(boolean fromUserCenter, User user) {
                String result = fromUserCenter ?
                        getString(R.string.switch_account_from_user_center, user) :
                        getString(R.string.switch_account_not_from_user_center, user);
                toastAndLog(result);
            }
        });
    }

    private void destroySDK() {
        if (mOpeCenter != null)
            mOpeCenter = null;
    }

    public void onLoginBtnClicked(final View view) {
        view.setClickable(false);
        // B: 登录
        if (!mOpeCenter.isLogin()) // 注意：SDK 只是检查当前运行时状态，游戏应该去服务端检查或者每次都调用登录接口
            mOpeCenter.login(OnlineGameActivity.this, new OperateCenter.OnLoginFinishedListener() {
                @Override
                public void onLoginFinished(boolean success, int resultCode, User user) {
                    String r = success ? getString(R.string.demo_success) : getString(R.string.demo_failed);
                    toastAndLog(getString(R.string.login_result, r, resultCode, user));
                    view.setClickable(true);
                    if (success) {
                        doGetArchive();
                    } else {
                        setArchiveStr(getString(R.string.m4399_ope_bz_cloud_archive_not_logged_in));
                    }
                }
            });
        else {
            toastAndLog(getString(R.string.login_already));
            view.setClickable(true);
        }
    }

    public void onRechargeBtnClicked(View view) {
        // C：充值
        String mark = createUniqueMark();
        mOpeCenter.recharge(this,
                // 充值金额，整数，单位元
                new Order(6, mark)
                        // 是否支持超出金额，默认不支持
                        .supportExcess(false)
                        // 商品名，可选，不传时认为商品名是游戏币
                        .commodity(getString(R.string.recharge_commodity_name)),
                new OperateCenter.OnRechargeFinishedListener() {
                    @Override
                    public void onRechargeFinished(boolean success, int resultCode, String msg) {
                        toastAndLog(resultCode + ": " + msg);
                    }
                });
    }

    public void onLogoutBtnClicked(View view) {
        // D：登出
        mOpeCenter.logout();
    }

    public void onCheckLoginBtnClicked(View view) {
        // 查询帐号是否在登录中
        toastAndLog(getString(mOpeCenter.isLogin() ? R.string.login_already : R.string.login_not_yet));
    }

    public void onShowUserBtnClicked(View view) {
        // 查询当前用户信息
        toastAndLog(String.valueOf(mOpeCenter.getCurrentAccount()));
    }

    public void onSaveArchiveBtnClicked(View view) {
        String archiveStr = mETArchive.getText().toString();
        onSaveArchive(archiveStr);
    }

    public void onReadArchiveBtnClicked(View view) {
        doGetArchive();
    }

    private void toastAndLog(String msg) {
        Toast.makeText(OnlineGameActivity.this, TAG + msg, Toast.LENGTH_SHORT).show();
        Log.d(TAG, msg);
    }

}
