package cn.m4399.operateBZ.phx;

import android.util.Base64;

import androidx.annotation.NonNull;

import org.json.JSONException;
import org.json.JSONObject;

import cn.m4399.operateBZ.User;

class RetValue extends JSONObject {
    static RetValue event(String event) {
        RetValue ret = new RetValue();
        ret.chain("event", event);
        return ret;
    }

    RetValue chain(String name, Object value) {
        try {
            putOpt(name, value);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }


    RetValue more(String name, Object value) {
        chain(name, value);
        return this;
    }

    RetValue user(User user) {
        chain("user", new RetValue()
                .chain("uid", user.getUid())
                .chain("name", user.getName())
                .chain("nick", user.getNick())
                .chain("state", user.getState()));
        return this;
    }

    RetValue data(@NonNull String data) {
        chain("data", Base64.encodeToString(data.getBytes(), Base64.NO_WRAP | Base64.URL_SAFE));
        return this;
    }
}
