const mockUser = {
  uid: "0000000002",
  name: "ope_phx_test_user",
  nick: "Happy"
}

export default {
  name: 'mockOpeBZPHX',

  initSDK: function (gameKey, orientation, compatNotch, callback) {
    let fn = 'initSDK';
    this._mockCall(fn, [gameKey, orientation, compatNotch],
      callback, {
        event: "init_finished",
        isLogin: "true",
        user: mockUser
      })
  },

  isLogin: function (callback) {
    let fn = 'isLogin';
  },

  getUser: function (callback) {
    let fn = 'getUser';
    this._mockCall(fn, null,
      callback, {
        event: "get_user",
        "user": {
          uid: "0000000002",
          name: "ope_phx_test_user",
          nick: "Happy"
        }
      })
  },

  login: function (callback) {
    let fn = 'login';
    this._mockCall(fn, [], callback, {
      event: "account_login",
      success: true,
      resultCode: 16,
      user: mockUser
    })
  },

  logout: function () {
    let fn = 'logout';
    this._mockCall(fn)
  },

  readArchive: function (callback) {
    let fn = 'readArchive';
    let now = Date.now();
    this._mockCall(fn, [], callback, {
      data: [{
        name: "ope_phx_warrior",
        headimg: "",
        level: "100",
        sex: "1",
        job: "",
        part: "",
        hp: "",
        ht: "",
        skill: [
          {id: 1, name: "劈柴刀法", level: 0, levelName: "第一重", value: 0},
          {id: 1, name: "鸿毛刀法", level: 0, levelName: "第一重", value: 0},
          {id: 1, name: "电击劈", level: 0, levelName: "第一重", value: 0},
          {id: 1, name: "雷霆斩", level: 0, levelName: "第一重", value: 0},
          {id: 1, name: "断岳斩", level: 0, levelName: "第一重", value: 0},
        ],
        createtime: new Date(now - 100000).toLocaleString(),
        updatetime: new Date(now - 4000).toLocaleString()
      }]
    })
  },

  recharge: function (money, mark, commodity, supportExcess, callback) {
    let fn = 'recharge';
    this._mockCall(fn, [money, commodity, mark, supportExcess],
      callback, {
        event: 'recharge_finished',
        success: true,
        message: '充值成功',
        resultCode: 0
      })
  },

  _androidLog: function (message) {
    console.log('Mock call _androidLog', message);
  },

  wrapJsCallback: function (funName, callback) {
    return retValue => {
      console.log(funName, retValue);
      let json = {};
      if (retValue) {
        json = JSON.parse(retValue);
        this._androidLog(json);
      }
      if (callback)
        callback(json);
    }
  },

  _mockCall: function (fn, args, callback, retValue) {
    console.log('Mock call ', fn, args);
    let _callback = this.wrapJsCallback(fn, callback);
    _callback(JSON.stringify(retValue));
  }
};


