import Phaser from 'phaser'
import StartScene from '@/game/scenes/StartScene'

function launch(containerId) {
  let GAME_WIDTH = document.documentElement.clientWidth;
  let GAME_HEIGHT = document.documentElement.clientHeight;
  return new Phaser.Game({
    title: '自在逍遥.风起',
    url: 'https://uniiao.cn',
    version: '1.0',
    type: Phaser.AUTO,//iOS不支持webGL 只能使用CANVAS
    width: GAME_WIDTH,
    height: GAME_HEIGHT,
    backgroundColor: '#292C44',
    parent: containerId,
    dom: {
      createContainer: true,
    },
    scale: {
      mode: Phaser.Scale.ENVELOP,//NONE,FIT
      parent: containerId,
      autoCenter: Phaser.Scale.NO_CENTER,
      width: GAME_WIDTH,
      height: GAME_HEIGHT,
    },
    physics: {
      default: 'arcade',
      arcade: {
        debug: false
      }
    },
    scene: [StartScene]
  })
}

export default launch
export {launch}
