module.exports = {
     plugins: {
          autoprefixer: {}, 
          "postcss-px-to-viewport": { 
              viewportWidth: 1334, // 定义转换时的 基准宽度（ui设计稿的宽度） 
              viewportHeight: 750, // 定义转换时的 基准高度（也可以不定义，不定义自动识别） 
              unitPrecision: 2, // 计算时保留的最大小数位数 
              viewportUnit: 'vw', // 转换后的基础单位 
              selectorBlackList: ['.ignore', '.hairlines'], // 定义项目中不需要转换样式 
              minPixelValue: 1, // 定义转换时的 最小值接线 
              mediaQuery: false, // 被定义在 @media 不进行转换操作 
              exclude: /(\/|\\)(node_modules)(\/|\\)/, // node_modules 文件夹中的样式不进行转换
              landscape: false, // 是否添加根据landscapeWidth生成的媒体查询条件 @media (orientation: landscape)
              landscapeUnit: 'vw', // 横屏时使用的单位
              landscapeWidth: 1334 // 横屏时使用的视窗宽度
           }
     }
}