/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.http.AndroidHttpClient;
import android.os.Build;
import androidx.annotation.NonNull;
import com.android.volley.Network;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.DiskBasedCache;
import com.android.volley.toolbox.HttpClientStack;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.HurlStack;
import java.io.File;
import org.apache.http.client.HttpClient;

public class Volley {
    private static final String DEFAULT_CACHE_DIR = "volley";

    @NonNull
    public static RequestQueue newRequestQueue(Context context, BaseHttpStack stack) {
        BasicNetwork network;
        if (stack == null) {
            if (Build.VERSION.SDK_INT >= 9) {
                network = new BasicNetwork(new HurlStack());
            } else {
                String userAgent = "volley/0";
                try {
                    String packageName = context.getPackageName();
                    PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
                    userAgent = packageName + "/" + info.versionCode;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                network = new BasicNetwork(new HttpClientStack((HttpClient)AndroidHttpClient.newInstance((String)userAgent)));
            }
        } else {
            network = new BasicNetwork(stack);
        }
        return Volley.newRequestQueue(context, network);
    }

    @Deprecated
    @NonNull
    public static RequestQueue newRequestQueue(Context context, HttpStack stack) {
        if (stack == null) {
            return Volley.newRequestQueue(context, (BaseHttpStack)null);
        }
        return Volley.newRequestQueue(context, new BasicNetwork(stack));
    }

    @NonNull
    private static RequestQueue newRequestQueue(Context context, Network network) {
        final Context appContext = context.getApplicationContext();
        DiskBasedCache.FileSupplier cacheSupplier = new DiskBasedCache.FileSupplier(){
            private File cacheDir = null;

            @Override
            public File get() {
                if (this.cacheDir == null) {
                    this.cacheDir = new File(appContext.getCacheDir(), Volley.DEFAULT_CACHE_DIR);
                }
                return this.cacheDir;
            }
        };
        RequestQueue queue = new RequestQueue(new DiskBasedCache(cacheSupplier), network);
        queue.start();
        return queue;
    }

    @NonNull
    public static RequestQueue newRequestQueue(Context context) {
        return Volley.newRequestQueue(context, (BaseHttpStack)null);
    }
}

