/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.android.volley.AsyncNetwork;
import com.android.volley.AuthFailureError;
import com.android.volley.Header;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestTask;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.AsyncHttpStack;
import com.android.volley.toolbox.ByteArrayPool;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.HttpResponse;
import com.android.volley.toolbox.NetworkUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class BasicAsyncNetwork
extends AsyncNetwork {
    private final AsyncHttpStack mAsyncStack;
    private final ByteArrayPool mPool;

    private BasicAsyncNetwork(AsyncHttpStack httpStack, ByteArrayPool pool) {
        this.mAsyncStack = httpStack;
        this.mPool = pool;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setBlockingExecutor(ExecutorService executor) {
        super.setBlockingExecutor(executor);
        this.mAsyncStack.setBlockingExecutor(executor);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setNonBlockingExecutor(ExecutorService executor) {
        super.setNonBlockingExecutor(executor);
        this.mAsyncStack.setNonBlockingExecutor(executor);
    }

    private void onRequestSucceeded(Request<?> request, long requestStartMs, HttpResponse httpResponse, AsyncNetwork.OnRequestComplete callback) {
        int statusCode = httpResponse.getStatusCode();
        List<Header> responseHeaders = httpResponse.getHeaders();
        if (statusCode == 304) {
            long requestDuration = SystemClock.elapsedRealtime() - requestStartMs;
            callback.onSuccess(NetworkUtility.getNotModifiedNetworkResponse(request, requestDuration, responseHeaders));
            return;
        }
        byte[] responseContents = httpResponse.getContentBytes();
        if (responseContents == null && httpResponse.getContent() == null) {
            responseContents = new byte[]{};
        }
        if (responseContents != null) {
            this.onResponseRead(requestStartMs, statusCode, httpResponse, request, callback, responseHeaders, responseContents);
            return;
        }
        InputStream inputStream = httpResponse.getContent();
        this.getBlockingExecutor().execute(new ResponseParsingTask(inputStream, httpResponse, request, callback, requestStartMs, responseHeaders, statusCode));
    }

    private void onRequestFailed(Request<?> request, AsyncNetwork.OnRequestComplete callback, IOException exception, long requestStartMs, @Nullable HttpResponse httpResponse, @Nullable byte[] responseContents) {
        try {
            NetworkUtility.RetryInfo retryInfo = NetworkUtility.shouldRetryException(request, exception, requestStartMs, httpResponse, responseContents);
            this.getBlockingExecutor().execute(new InvokeRetryPolicyTask(request, retryInfo, callback));
        }
        catch (VolleyError volleyError) {
            callback.onError(volleyError);
        }
    }

    @Override
    public void performRequest(final Request<?> request, final AsyncNetwork.OnRequestComplete callback) {
        if (this.getBlockingExecutor() == null) {
            throw new IllegalStateException("mBlockingExecuter must be set before making a request");
        }
        final long requestStartMs = SystemClock.elapsedRealtime();
        Map<String, String> additionalRequestHeaders = HttpHeaderParser.getCacheHeaders(request.getCacheEntry());
        this.mAsyncStack.executeRequest(request, additionalRequestHeaders, new AsyncHttpStack.OnRequestComplete(){

            @Override
            public void onSuccess(HttpResponse httpResponse) {
                BasicAsyncNetwork.this.onRequestSucceeded(request, requestStartMs, httpResponse, callback);
            }

            @Override
            public void onAuthError(AuthFailureError authFailureError) {
                callback.onError(authFailureError);
            }

            @Override
            public void onError(IOException ioException) {
                BasicAsyncNetwork.this.onRequestFailed(request, callback, ioException, requestStartMs, null, null);
            }
        });
    }

    private void onResponseRead(long requestStartMs, int statusCode, HttpResponse httpResponse, Request<?> request, AsyncNetwork.OnRequestComplete callback, List<Header> responseHeaders, byte[] responseContents) {
        long requestLifetime = SystemClock.elapsedRealtime() - requestStartMs;
        NetworkUtility.logSlowRequests(requestLifetime, request, responseContents, statusCode);
        if (statusCode < 200 || statusCode > 299) {
            this.onRequestFailed(request, callback, new IOException(), requestStartMs, httpResponse, responseContents);
            return;
        }
        callback.onSuccess(new NetworkResponse(statusCode, responseContents, false, SystemClock.elapsedRealtime() - requestStartMs, responseHeaders));
    }

    public static class Builder {
        private static final int DEFAULT_POOL_SIZE = 4096;
        @NonNull
        private AsyncHttpStack mAsyncStack;
        private ByteArrayPool mPool;

        public Builder(@NonNull AsyncHttpStack httpStack) {
            this.mAsyncStack = httpStack;
            this.mPool = null;
        }

        public Builder setPool(ByteArrayPool pool) {
            this.mPool = pool;
            return this;
        }

        public BasicAsyncNetwork build() {
            if (this.mPool == null) {
                this.mPool = new ByteArrayPool(4096);
            }
            return new BasicAsyncNetwork(this.mAsyncStack, this.mPool);
        }
    }

    private class ResponseParsingTask<T>
    extends RequestTask<T> {
        InputStream inputStream;
        HttpResponse httpResponse;
        Request<T> request;
        AsyncNetwork.OnRequestComplete callback;
        long requestStartMs;
        List<Header> responseHeaders;
        int statusCode;

        ResponseParsingTask(InputStream inputStream, HttpResponse httpResponse, Request<T> request, AsyncNetwork.OnRequestComplete callback, long requestStartMs, List<Header> responseHeaders, int statusCode) {
            super(request);
            this.inputStream = inputStream;
            this.httpResponse = httpResponse;
            this.request = request;
            this.callback = callback;
            this.requestStartMs = requestStartMs;
            this.responseHeaders = responseHeaders;
            this.statusCode = statusCode;
        }

        @Override
        public void run() {
            byte[] finalResponseContents;
            try {
                finalResponseContents = NetworkUtility.inputStreamToBytes(this.inputStream, this.httpResponse.getContentLength(), BasicAsyncNetwork.this.mPool);
            }
            catch (IOException e) {
                BasicAsyncNetwork.this.onRequestFailed(this.request, this.callback, e, this.requestStartMs, this.httpResponse, null);
                return;
            }
            BasicAsyncNetwork.this.onResponseRead(this.requestStartMs, this.statusCode, this.httpResponse, this.request, this.callback, this.responseHeaders, finalResponseContents);
        }
    }

    private class InvokeRetryPolicyTask<T>
    extends RequestTask<T> {
        final Request<T> request;
        final NetworkUtility.RetryInfo retryInfo;
        final AsyncNetwork.OnRequestComplete callback;

        InvokeRetryPolicyTask(Request<T> request, NetworkUtility.RetryInfo retryInfo, AsyncNetwork.OnRequestComplete callback) {
            super(request);
            this.request = request;
            this.retryInfo = retryInfo;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                NetworkUtility.attemptRetryOnException(this.request, this.retryInfo);
                BasicAsyncNetwork.this.performRequest(this.request, this.callback);
            }
            catch (VolleyError e) {
                this.callback.onError(e);
            }
        }
    }
}

