/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.volley.CacheDispatcher;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

class WaitingRequestManager
implements Request.NetworkRequestCompleteListener {
    private final Map<String, List<Request<?>>> mWaitingRequests = new HashMap();
    private final ResponseDelivery mResponseDelivery;
    @Nullable
    private final RequestQueue mRequestQueue;
    @Nullable
    private final CacheDispatcher mCacheDispatcher;
    @Nullable
    private final BlockingQueue<Request<?>> mNetworkQueue;

    WaitingRequestManager(@NonNull RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        this.mResponseDelivery = this.mRequestQueue.getResponseDelivery();
        this.mCacheDispatcher = null;
        this.mNetworkQueue = null;
    }

    WaitingRequestManager(@NonNull CacheDispatcher cacheDispatcher, @NonNull BlockingQueue<Request<?>> networkQueue, ResponseDelivery responseDelivery) {
        this.mRequestQueue = null;
        this.mResponseDelivery = responseDelivery;
        this.mCacheDispatcher = cacheDispatcher;
        this.mNetworkQueue = networkQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponseReceived(Request<?> request, Response<?> response) {
        List<Request<?>> waitingRequests;
        if (response.cacheEntry == null || response.cacheEntry.isExpired()) {
            this.onNoUsableResponseReceived(request);
            return;
        }
        String cacheKey = request.getCacheKey();
        WaitingRequestManager waitingRequestManager = this;
        synchronized (waitingRequestManager) {
            waitingRequests = this.mWaitingRequests.remove(cacheKey);
        }
        if (waitingRequests != null) {
            if (VolleyLog.DEBUG) {
                VolleyLog.v("Releasing %d waiting requests for cacheKey=%s.", waitingRequests.size(), cacheKey);
            }
            for (Request request2 : waitingRequests) {
                this.mResponseDelivery.postResponse(request2, response);
            }
        }
    }

    @Override
    public synchronized void onNoUsableResponseReceived(Request<?> request) {
        String cacheKey = request.getCacheKey();
        List<Request<?>> waitingRequests = this.mWaitingRequests.remove(cacheKey);
        if (waitingRequests != null && !waitingRequests.isEmpty()) {
            if (VolleyLog.DEBUG) {
                VolleyLog.v("%d waiting requests for cacheKey=%s; resend to network", waitingRequests.size(), cacheKey);
            }
            Request<?> nextInLine = waitingRequests.remove(0);
            this.mWaitingRequests.put(cacheKey, waitingRequests);
            nextInLine.setNetworkRequestCompleteListener(this);
            if (this.mRequestQueue != null) {
                this.mRequestQueue.sendRequestOverNetwork(nextInLine);
            } else if (this.mCacheDispatcher != null && this.mNetworkQueue != null) {
                try {
                    this.mNetworkQueue.put(nextInLine);
                }
                catch (InterruptedException iex) {
                    VolleyLog.e("Couldn't add request to queue. %s", iex.toString());
                    Thread.currentThread().interrupt();
                    this.mCacheDispatcher.quit();
                }
            }
        }
    }

    synchronized boolean maybeAddToWaitingRequests(Request<?> request) {
        String cacheKey = request.getCacheKey();
        if (this.mWaitingRequests.containsKey(cacheKey)) {
            List<Request<?>> stagedRequests = this.mWaitingRequests.get(cacheKey);
            if (stagedRequests == null) {
                stagedRequests = new ArrayList();
            }
            request.addMarker("waiting-for-response");
            stagedRequests.add(request);
            this.mWaitingRequests.put(cacheKey, stagedRequests);
            if (VolleyLog.DEBUG) {
                VolleyLog.d("Request for cacheKey=%s is in flight, putting on hold.", cacheKey);
            }
            return true;
        }
        this.mWaitingRequests.put(cacheKey, null);
        request.setNetworkRequestCompleteListener(this);
        if (VolleyLog.DEBUG) {
            VolleyLog.d("new request, sending to network %s", cacheKey);
        }
        return false;
    }
}

