/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import androidx.annotation.Nullable;
import com.android.volley.Cache;
import com.android.volley.VolleyError;

public class Response<T> {
    @Nullable
    public final T result;
    @Nullable
    public final Cache.Entry cacheEntry;
    @Nullable
    public final VolleyError error;
    public boolean intermediate = false;

    public static <T> Response<T> success(@Nullable T result, @Nullable Cache.Entry cacheEntry) {
        return new Response<T>(result, cacheEntry);
    }

    public static <T> Response<T> error(VolleyError error) {
        return new Response<T>(error);
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    private Response(@Nullable T result, @Nullable Cache.Entry cacheEntry) {
        this.result = result;
        this.cacheEntry = cacheEntry;
        this.error = null;
    }

    private Response(VolleyError error) {
        this.result = null;
        this.cacheEntry = null;
        this.error = error;
    }

    public static interface ErrorListener {
        public void onErrorResponse(VolleyError var1);
    }

    public static interface Listener<T> {
        public void onResponse(T var1);
    }
}

