/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.Handler;
import android.os.Looper;
import com.android.volley.Cache;
import com.android.volley.CacheDispatcher;
import com.android.volley.ExecutorDelivery;
import com.android.volley.Network;
import com.android.volley.NetworkDispatcher;
import com.android.volley.Request;
import com.android.volley.ResponseDelivery;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestQueue {
    private final AtomicInteger mSequenceGenerator = new AtomicInteger();
    private final Set<Request<?>> mCurrentRequests = new HashSet();
    private final PriorityBlockingQueue<Request<?>> mCacheQueue = new PriorityBlockingQueue();
    private final PriorityBlockingQueue<Request<?>> mNetworkQueue = new PriorityBlockingQueue();
    private static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    private final Cache mCache;
    private final Network mNetwork;
    private final ResponseDelivery mDelivery;
    private final NetworkDispatcher[] mDispatchers;
    private CacheDispatcher mCacheDispatcher;
    private final List<RequestFinishedListener> mFinishedListeners = new ArrayList<RequestFinishedListener>();
    private final List<RequestEventListener> mEventListeners = new ArrayList<RequestEventListener>();

    public RequestQueue(Cache cache, Network network, int threadPoolSize, ResponseDelivery delivery) {
        this.mCache = cache;
        this.mNetwork = network;
        this.mDispatchers = new NetworkDispatcher[threadPoolSize];
        this.mDelivery = delivery;
    }

    public RequestQueue(Cache cache, Network network, int threadPoolSize) {
        this(cache, network, threadPoolSize, new ExecutorDelivery(new Handler(Looper.getMainLooper())));
    }

    public RequestQueue(Cache cache, Network network) {
        this(cache, network, 4);
    }

    public void start() {
        this.stop();
        this.mCacheDispatcher = new CacheDispatcher(this.mCacheQueue, this.mNetworkQueue, this.mCache, this.mDelivery);
        this.mCacheDispatcher.start();
        for (int i = 0; i < this.mDispatchers.length; ++i) {
            NetworkDispatcher networkDispatcher;
            this.mDispatchers[i] = networkDispatcher = new NetworkDispatcher(this.mNetworkQueue, this.mNetwork, this.mCache, this.mDelivery);
            networkDispatcher.start();
        }
    }

    public void stop() {
        if (this.mCacheDispatcher != null) {
            this.mCacheDispatcher.quit();
        }
        for (NetworkDispatcher mDispatcher : this.mDispatchers) {
            if (mDispatcher == null) continue;
            mDispatcher.quit();
        }
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    public Cache getCache() {
        return this.mCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(RequestFilter filter) {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            for (Request<?> request : this.mCurrentRequests) {
                if (!filter.apply(request)) continue;
                request.cancel();
            }
        }
    }

    public void cancelAll(final Object tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Cannot cancelAll with a null tag");
        }
        this.cancelAll(new RequestFilter(){

            @Override
            public boolean apply(Request<?> request) {
                return request.getTag() == tag;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Request<T> add(Request<T> request) {
        request.setRequestQueue(this);
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        request.addMarker("add-to-queue");
        this.sendRequestEvent(request, 0);
        this.beginRequest(request);
        return request;
    }

    <T> void beginRequest(Request<T> request) {
        if (!request.shouldCache()) {
            this.sendRequestOverNetwork(request);
        } else {
            this.mCacheQueue.add(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void finish(Request<T> request) {
        Collection<Object> collection = this.mCurrentRequests;
        synchronized (collection) {
            this.mCurrentRequests.remove(request);
        }
        collection = this.mFinishedListeners;
        synchronized (collection) {
            for (RequestFinishedListener listener : this.mFinishedListeners) {
                listener.onRequestFinished(request);
            }
        }
        this.sendRequestEvent(request, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRequestEvent(Request<?> request, int event) {
        List<RequestEventListener> list = this.mEventListeners;
        synchronized (list) {
            for (RequestEventListener listener : this.mEventListeners) {
                listener.onRequestEvent(request, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestEventListener(RequestEventListener listener) {
        List<RequestEventListener> list = this.mEventListeners;
        synchronized (list) {
            this.mEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestEventListener(RequestEventListener listener) {
        List<RequestEventListener> list = this.mEventListeners;
        synchronized (list) {
            this.mEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <T> void addRequestFinishedListener(RequestFinishedListener<T> listener) {
        List<RequestFinishedListener> list = this.mFinishedListeners;
        synchronized (list) {
            this.mFinishedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <T> void removeRequestFinishedListener(RequestFinishedListener<T> listener) {
        List<RequestFinishedListener> list = this.mFinishedListeners;
        synchronized (list) {
            this.mFinishedListeners.remove(listener);
        }
    }

    public ResponseDelivery getResponseDelivery() {
        return this.mDelivery;
    }

    <T> void sendRequestOverNetwork(Request<T> request) {
        this.mNetworkQueue.add(request);
    }

    public static interface RequestFilter {
        public boolean apply(Request<?> var1);
    }

    public static interface RequestEventListener {
        public void onRequestEvent(Request<?> var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestEvent {
        public static final int REQUEST_QUEUED = 0;
        public static final int REQUEST_CACHE_LOOKUP_STARTED = 1;
        public static final int REQUEST_CACHE_LOOKUP_FINISHED = 2;
        public static final int REQUEST_NETWORK_DISPATCH_STARTED = 3;
        public static final int REQUEST_NETWORK_DISPATCH_FINISHED = 4;
        public static final int REQUEST_FINISHED = 5;
    }

    @Deprecated
    public static interface RequestFinishedListener<T> {
        public void onRequestFinished(Request<T> var1);
    }
}

