/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.volley.AsyncCache;
import com.android.volley.AsyncNetwork;
import com.android.volley.Cache;
import com.android.volley.ExecutorDelivery;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RequestTask;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyError;
import com.android.volley.WaitingRequestManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncRequestQueue
extends RequestQueue {
    private static final int DEFAULT_BLOCKING_THREAD_POOL_SIZE = 4;
    @Nullable
    private final AsyncCache mAsyncCache;
    private final AsyncNetwork mNetwork;
    private ExecutorService mNonBlockingExecutor;
    private ScheduledExecutorService mNonBlockingScheduledExecutor;
    private ExecutorService mBlockingExecutor;
    private ExecutorFactory mExecutorFactory;
    private final WaitingRequestManager mWaitingRequestManager = new WaitingRequestManager(this);
    private final List<Request<?>> mRequestsAwaitingCacheInitialization = new ArrayList();
    private volatile boolean mIsCacheInitialized = false;
    private final Object mCacheInitializationLock = new Object[0];

    private AsyncRequestQueue(Cache cache, AsyncNetwork network, @Nullable AsyncCache asyncCache, ResponseDelivery responseDelivery, ExecutorFactory executorFactory) {
        super(cache, network, 0, responseDelivery);
        this.mAsyncCache = asyncCache;
        this.mNetwork = network;
        this.mExecutorFactory = executorFactory;
    }

    @Override
    public void start() {
        this.stop();
        this.mNonBlockingExecutor = this.mExecutorFactory.createNonBlockingExecutor(AsyncRequestQueue.getBlockingQueue());
        this.mBlockingExecutor = this.mExecutorFactory.createBlockingExecutor(AsyncRequestQueue.getBlockingQueue());
        this.mNonBlockingScheduledExecutor = this.mExecutorFactory.createNonBlockingScheduledExecutor();
        this.mNetwork.setBlockingExecutor(this.mBlockingExecutor);
        this.mNetwork.setNonBlockingExecutor(this.mNonBlockingExecutor);
        this.mNetwork.setNonBlockingScheduledExecutor(this.mNonBlockingScheduledExecutor);
        if (this.mAsyncCache != null) {
            this.mNonBlockingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AsyncRequestQueue.this.mAsyncCache.initialize(new AsyncCache.OnWriteCompleteCallback(){

                        @Override
                        public void onWriteComplete() {
                            AsyncRequestQueue.this.onCacheInitializationComplete();
                        }
                    });
                }
            });
        } else {
            this.mBlockingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AsyncRequestQueue.this.getCache().initialize();
                    AsyncRequestQueue.this.mNonBlockingExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            AsyncRequestQueue.this.onCacheInitializationComplete();
                        }
                    });
                }
            });
        }
    }

    @Override
    public void stop() {
        if (this.mNonBlockingExecutor != null) {
            this.mNonBlockingExecutor.shutdownNow();
            this.mNonBlockingExecutor = null;
        }
        if (this.mBlockingExecutor != null) {
            this.mBlockingExecutor.shutdownNow();
            this.mBlockingExecutor = null;
        }
        if (this.mNonBlockingScheduledExecutor != null) {
            this.mNonBlockingScheduledExecutor.shutdownNow();
            this.mNonBlockingScheduledExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> void beginRequest(Request<T> request) {
        if (!this.mIsCacheInitialized) {
            Object object = this.mCacheInitializationLock;
            synchronized (object) {
                if (!this.mIsCacheInitialized) {
                    this.mRequestsAwaitingCacheInitialization.add(request);
                    return;
                }
            }
        }
        if (request.shouldCache()) {
            if (this.mAsyncCache != null) {
                this.mNonBlockingExecutor.execute(new CacheTask<T>(request));
            } else {
                this.mBlockingExecutor.execute(new CacheTask<T>(request));
            }
        } else {
            this.sendRequestOverNetwork(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCacheInitializationComplete() {
        ArrayList requestsToDispatch;
        Iterator iterator = this.mCacheInitializationLock;
        synchronized (iterator) {
            requestsToDispatch = new ArrayList(this.mRequestsAwaitingCacheInitialization);
            this.mRequestsAwaitingCacheInitialization.clear();
            this.mIsCacheInitialized = true;
        }
        for (Request request : requestsToDispatch) {
            this.beginRequest(request);
        }
    }

    @Override
    <T> void sendRequestOverNetwork(Request<T> request) {
        this.mNonBlockingExecutor.execute(new NetworkTask<T>(request));
    }

    private void handleEntry(Cache.Entry entry, Request<?> mRequest) {
        if (entry == null) {
            mRequest.addMarker("cache-miss");
            if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(mRequest)) {
                this.sendRequestOverNetwork(mRequest);
            }
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (entry.isExpired(currentTimeMillis)) {
            mRequest.addMarker("cache-hit-expired");
            mRequest.setCacheEntry(entry);
            if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(mRequest)) {
                this.sendRequestOverNetwork(mRequest);
            }
            return;
        }
        this.mBlockingExecutor.execute(new CacheParseTask(mRequest, entry, currentTimeMillis));
    }

    private void finishRequest(Request<?> mRequest, Response<?> response, boolean cached) {
        if (cached) {
            mRequest.addMarker("network-cache-written");
        }
        mRequest.markDelivered();
        this.getResponseDelivery().postResponse(mRequest, response);
        mRequest.notifyListenerResponseReceived(response);
    }

    private static PriorityBlockingQueue<Runnable> getBlockingQueue() {
        return new PriorityBlockingQueue<Runnable>(11, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable r1, Runnable r2) {
                if (r1 instanceof RequestTask) {
                    if (r2 instanceof RequestTask) {
                        return ((RequestTask)r1).compareTo((RequestTask)r2);
                    }
                    return 1;
                }
                return r2 instanceof RequestTask ? -1 : 0;
            }
        });
    }

    private static class ThrowingCache
    implements Cache {
        private ThrowingCache() {
        }

        @Override
        public Cache.Entry get(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(String key, Cache.Entry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void initialize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invalidate(String key, boolean fullExpire) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder {
        @Nullable
        private AsyncCache mAsyncCache = null;
        private final AsyncNetwork mNetwork;
        @Nullable
        private Cache mCache = null;
        @Nullable
        private ExecutorFactory mExecutorFactory = null;
        @Nullable
        private ResponseDelivery mResponseDelivery = null;

        public Builder(AsyncNetwork asyncNetwork) {
            if (asyncNetwork == null) {
                throw new IllegalArgumentException("Network cannot be null");
            }
            this.mNetwork = asyncNetwork;
        }

        public Builder setExecutorFactory(ExecutorFactory executorFactory) {
            this.mExecutorFactory = executorFactory;
            return this;
        }

        public Builder setResponseDelivery(ResponseDelivery responseDelivery) {
            this.mResponseDelivery = responseDelivery;
            return this;
        }

        public Builder setAsyncCache(AsyncCache asyncCache) {
            this.mAsyncCache = asyncCache;
            return this;
        }

        public Builder setCache(Cache cache) {
            this.mCache = cache;
            return this;
        }

        private ExecutorFactory getDefaultExecutorFactory() {
            return new ExecutorFactory(){

                @Override
                public ExecutorService createNonBlockingExecutor(BlockingQueue<Runnable> taskQueue) {
                    return this.getNewThreadPoolExecutor(1, "Non-BlockingExecutor", taskQueue);
                }

                @Override
                public ExecutorService createBlockingExecutor(BlockingQueue<Runnable> taskQueue) {
                    return this.getNewThreadPoolExecutor(4, "BlockingExecutor", taskQueue);
                }

                @Override
                public ScheduledExecutorService createNonBlockingScheduledExecutor() {
                    return new ScheduledThreadPoolExecutor(0, this.getThreadFactory("ScheduledExecutor"));
                }

                private ThreadPoolExecutor getNewThreadPoolExecutor(int maximumPoolSize, String threadNameSuffix, BlockingQueue<Runnable> taskQueue) {
                    return new ThreadPoolExecutor(0, maximumPoolSize, 60L, TimeUnit.SECONDS, taskQueue, this.getThreadFactory(threadNameSuffix));
                }

                private ThreadFactory getThreadFactory(final String threadNameSuffix) {
                    return new ThreadFactory(){

                        @Override
                        public Thread newThread(@NonNull Runnable runnable) {
                            Thread t = Executors.defaultThreadFactory().newThread(runnable);
                            t.setName("Volley-" + threadNameSuffix);
                            return t;
                        }
                    };
                }
            };
        }

        public AsyncRequestQueue build() {
            if (this.mCache == null && this.mAsyncCache == null) {
                throw new IllegalArgumentException("You must set one of the cache objects");
            }
            if (this.mCache == null) {
                this.mCache = new ThrowingCache();
            }
            if (this.mResponseDelivery == null) {
                this.mResponseDelivery = new ExecutorDelivery(new Handler(Looper.getMainLooper()));
            }
            if (this.mExecutorFactory == null) {
                this.mExecutorFactory = this.getDefaultExecutorFactory();
            }
            return new AsyncRequestQueue(this.mCache, this.mNetwork, this.mAsyncCache, this.mResponseDelivery, this.mExecutorFactory);
        }
    }

    public static abstract class ExecutorFactory {
        public abstract ExecutorService createNonBlockingExecutor(BlockingQueue<Runnable> var1);

        public abstract ExecutorService createBlockingExecutor(BlockingQueue<Runnable> var1);

        public abstract ScheduledExecutorService createNonBlockingScheduledExecutor();
    }

    private class CachePutTask<T>
    extends RequestTask<T> {
        Response<?> response;

        CachePutTask(Request<T> request, Response<?> response) {
            super(request);
            this.response = response;
        }

        @Override
        public void run() {
            if (AsyncRequestQueue.this.mAsyncCache != null) {
                AsyncRequestQueue.this.mAsyncCache.put(this.mRequest.getCacheKey(), this.response.cacheEntry, new AsyncCache.OnWriteCompleteCallback(){

                    @Override
                    public void onWriteComplete() {
                        AsyncRequestQueue.this.finishRequest(CachePutTask.this.mRequest, CachePutTask.this.response, true);
                    }
                });
            } else {
                AsyncRequestQueue.this.getCache().put(this.mRequest.getCacheKey(), this.response.cacheEntry);
                AsyncRequestQueue.this.finishRequest(this.mRequest, this.response, true);
            }
        }
    }

    private class NetworkParseTask<T>
    extends RequestTask<T> {
        NetworkResponse networkResponse;

        NetworkParseTask(Request<T> request, NetworkResponse networkResponse) {
            super(request);
            this.networkResponse = networkResponse;
        }

        @Override
        public void run() {
            Response response = this.mRequest.parseNetworkResponse(this.networkResponse);
            this.mRequest.addMarker("network-parse-complete");
            if (this.mRequest.shouldCache() && response.cacheEntry != null) {
                if (AsyncRequestQueue.this.mAsyncCache != null) {
                    AsyncRequestQueue.this.mNonBlockingExecutor.execute(new CachePutTask(this.mRequest, response));
                } else {
                    AsyncRequestQueue.this.mBlockingExecutor.execute(new CachePutTask(this.mRequest, response));
                }
            } else {
                AsyncRequestQueue.this.finishRequest(this.mRequest, response, false);
            }
        }
    }

    private class NetworkTask<T>
    extends RequestTask<T> {
        NetworkTask(Request<T> request) {
            super(request);
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("network-discard-cancelled");
                this.mRequest.notifyListenerResponseNotUsable();
                return;
            }
            final long startTimeMs = SystemClock.elapsedRealtime();
            this.mRequest.addMarker("network-queue-take");
            AsyncRequestQueue.this.mNetwork.performRequest(this.mRequest, new AsyncNetwork.OnRequestComplete(){

                @Override
                public void onSuccess(NetworkResponse networkResponse) {
                    NetworkTask.this.mRequest.addMarker("network-http-complete");
                    if (networkResponse.notModified && NetworkTask.this.mRequest.hasHadResponseDelivered()) {
                        NetworkTask.this.mRequest.finish("not-modified");
                        NetworkTask.this.mRequest.notifyListenerResponseNotUsable();
                        return;
                    }
                    AsyncRequestQueue.this.mBlockingExecutor.execute(new NetworkParseTask(NetworkTask.this.mRequest, networkResponse));
                }

                @Override
                public void onError(VolleyError volleyError) {
                    volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - startTimeMs);
                    AsyncRequestQueue.this.mBlockingExecutor.execute(new ParseErrorTask(NetworkTask.this.mRequest, volleyError));
                }
            });
        }
    }

    private class ParseErrorTask<T>
    extends RequestTask<T> {
        VolleyError volleyError;

        ParseErrorTask(Request<T> request, VolleyError volleyError) {
            super(request);
            this.volleyError = volleyError;
        }

        @Override
        public void run() {
            VolleyError parsedError = this.mRequest.parseNetworkError(this.volleyError);
            AsyncRequestQueue.this.getResponseDelivery().postError(this.mRequest, parsedError);
            this.mRequest.notifyListenerResponseNotUsable();
        }
    }

    private class CacheParseTask<T>
    extends RequestTask<T> {
        Cache.Entry entry;
        long startTimeMillis;

        CacheParseTask(Request<T> request, Cache.Entry entry, long startTimeMillis) {
            super(request);
            this.entry = entry;
            this.startTimeMillis = startTimeMillis;
        }

        @Override
        public void run() {
            this.mRequest.addMarker("cache-hit");
            Response response = this.mRequest.parseNetworkResponse(new NetworkResponse(200, this.entry.data, false, 0L, this.entry.allResponseHeaders));
            this.mRequest.addMarker("cache-hit-parsed");
            if (!this.entry.refreshNeeded(this.startTimeMillis)) {
                AsyncRequestQueue.this.getResponseDelivery().postResponse(this.mRequest, response);
            } else {
                this.mRequest.addMarker("cache-hit-refresh-needed");
                this.mRequest.setCacheEntry(this.entry);
                response.intermediate = true;
                if (!AsyncRequestQueue.this.mWaitingRequestManager.maybeAddToWaitingRequests(this.mRequest)) {
                    AsyncRequestQueue.this.getResponseDelivery().postResponse(this.mRequest, response, new Runnable(){

                        @Override
                        public void run() {
                            AsyncRequestQueue.this.sendRequestOverNetwork(CacheParseTask.this.mRequest);
                        }
                    });
                } else {
                    AsyncRequestQueue.this.getResponseDelivery().postResponse(this.mRequest, response);
                }
            }
        }
    }

    private class CacheTask<T>
    extends RequestTask<T> {
        CacheTask(Request<T> request) {
            super(request);
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("cache-discard-canceled");
                return;
            }
            this.mRequest.addMarker("cache-queue-take");
            if (AsyncRequestQueue.this.mAsyncCache != null) {
                AsyncRequestQueue.this.mAsyncCache.get(this.mRequest.getCacheKey(), new AsyncCache.OnGetCompleteCallback(){

                    @Override
                    public void onGetComplete(Cache.Entry entry) {
                        AsyncRequestQueue.this.handleEntry(entry, CacheTask.this.mRequest);
                    }
                });
            } else {
                Cache.Entry entry = AsyncRequestQueue.this.getCache().get(this.mRequest.getCacheKey());
                AsyncRequestQueue.this.handleEntry(entry, this.mRequest);
            }
        }
    }
}

