﻿using UnityEngine;

namespace cn.m4399.operate.api
{
    public class ChartItem
    {
        private AndroidJavaObject JavaObject;

        internal ChartItem(AndroidJavaObject javaObject)
        {
            JavaObject = javaObject;
        }

        /// <summary>
        /// 排名
        /// </summary>
        /// <returns></returns>
        public string GetRank()
        {
            return JavaObject.Get<string>("rank");
        }

        /// <summary>
        /// 角色头像地址
        /// </summary>
        /// <returns></returns>
        public string GetRoleAvatar()
        {
            return JavaObject.Get<string>("roleAvatar");
        }

        /// <summary>
        /// 角色ID
        /// </summary>
        /// <returns></returns>
        public string GetRoleId()
        {
            return JavaObject.Get<string>("roleId");
        }

        /// <summary>
        /// 角色名
        /// </summary>
        /// <returns></returns>
        public string GetRoleName()
        {
            return JavaObject.Get<string>("roleName");
        }
    }
}
