﻿using UnityEngine;

namespace cn.m4399.operate.api
{
    public class AchievementDetail
    {
        private AndroidJavaObject JavaObject;

        internal AchievementDetail(AndroidJavaObject javaObject)
        {
            JavaObject = javaObject;
        }

        /// <summary>
        /// 成就名称
        /// </summary>
        /// <returns></returns>
        public string GetName()
        {
            return JavaObject.Get<string>("name");
        }

        /// <summary>
        /// 成就Id
        /// </summary>
        /// <returns></returns>
        public string GetId()
        {
            return JavaObject.Get<string>("id");
        }

        /// <summary>
        /// 成就总步数
        /// </summary>
        /// <returns></returns>
        public int GetTotalStepCounted()
        {
            return JavaObject.Get<int>("totalStepCounted");
        }

        /// <summary>
        /// 是否隐藏
        /// </summary>
        /// <returns></returns>
        public bool IsHide()
        {
            return JavaObject.Get<bool>("isHide");
        }

        /// <summary>
        /// 成就稀有度
        /// </summary>
        /// <returns></returns>
        public RarityStatistics GetRarityStatistics()
        {
            return new RarityStatistics(JavaObject.Get<AndroidJavaObject>("rarityStatistics"));
        }

        /// <summary>
        /// 个人成就详情
        /// </summary>
        /// <returns></returns>
        public PersonalAchieve GetPersonalAchieve()
        {
            return new PersonalAchieve(JavaObject.Get<AndroidJavaObject>("personalAchieve"));
        }

        public class RarityStatistics
        {
            private AndroidJavaObject rarityStatisticsJavaObject;

            internal RarityStatistics(AndroidJavaObject javaObject)
            {
                rarityStatisticsJavaObject = javaObject;
            }

            /// <summary>
            /// 已完成人数
            /// </summary>
            /// <returns></returns>
            public int GetCountCompleted()
            {
                return rarityStatisticsJavaObject.Get<int>("countCompleted");
            }

            /// <summary>
            /// 参与完成成就总人数
            /// </summary>
            /// <returns></returns>
            public int GetCountAll()
            {
                return rarityStatisticsJavaObject.Get<int>("countAll");
            }
        }

        public class PersonalAchieve
        {
            private AndroidJavaObject personalAchieveJavaObject;

            internal PersonalAchieve(AndroidJavaObject javaObject)
            {
                personalAchieveJavaObject = javaObject;
            }

            /// <summary>
            /// 成就达成时间
            /// </summary>
            /// <returns></returns>
            public string GetAchieveTime()
            {
                return personalAchieveJavaObject.Get<string>("achieveTime");
            }

            /// <summary>
            /// 成就当前进度
            /// </summary>
            /// <returns></returns>
            public string GetCurrentSteps()
            {
                return personalAchieveJavaObject.Get<string>("currentSteps");
            }
        }

    }
}
