﻿using System.Threading;
using UnityEngine;

namespace cn.m4399.operate
{
    /// <summary>
    /// SDK 通用跳转
    /// </summary>
    public class OperateAction
    {

        private const string OPERATE_ACTION_JAVA_CLASS_NAME = "cn.m4399.operate.OperateAction";

        /// <summary>
        /// 是否支持 key 的协议
        /// </summary>
        /// <param name="key"></param>
        /// <param name="listener"></param>
        public static void Support(string key, OpeResultListener listener)
        {
            UnityAndroid.RunOnUiThread(new AndroidJavaRunnable(() =>
            {
                using (var javaClass = new AndroidJavaClass(OPERATE_ACTION_JAVA_CLASS_NAME))
                {
                    javaClass.CallStatic("support", key, listener);
                }
            }));
        }

        /// <summary>
        /// 协议跳转
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static int Perform(string key)
        {
            var ret = 37;
            var semaphore = new Semaphore(0, 1);
            UnityAndroid.RunOnUiThread(new AndroidJavaRunnable(() =>
            {
                using (var javaClass = new AndroidJavaClass(OPERATE_ACTION_JAVA_CLASS_NAME))
                {
                    ret = javaClass.CallStatic<int>("perform", key);
                    semaphore.Release();
                }
            }));
            semaphore.WaitOne();
            return ret;
        }
    }
}
