﻿using UnityEngine;

namespace cn.m4399.operate
{
    /// <summary>
    /// 独代SDK功能 主接口类
    /// 4399 sdk
    /// </summary>
    public class ExclusiveAgent
    {
        private const string EXCLUSIVE_AGENT_JAVA_CLASS_NAME = "cn.m4399.operate.ExclusiveAgent";

        /// <summary>
        /// 初始化SDK
        /// </summary>
        /// <param name="operateConfig"></param>
        /// <param name="onInitGlobalListener"></param>
        public static void Init(OperateConfig operateConfig, OnInitGlobalListener onInitGlobalListener)
        {
            UnityAndroid.RunOnUiThread(new AndroidJavaRunnable(() =>
            {
                using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
                {
                    javaClass.CallStatic("init", UnityAndroid.GetUnityActivity(), operateConfig.GetJavaObject(), onInitGlobalListener);
                }
            }));
        }

        /// <summary>
        /// 打开活动详情页
        /// </summary>
        /// <param name="activityId"></param>
        public static void OpenActivityDetailById(string activityId)
        {
            UnityAndroid.RunOnUiThread(new AndroidJavaRunnable(() =>
            {
                using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
                {
                    javaClass.CallStatic("openActivityDetailById", UnityAndroid.GetUnityActivity(), activityId);
                }
            }));

        }

        /// <summary>
        /// 使用活动码
        /// </summary>
        /// <param name="activityId"></param>
        /// <param name="activityCode"></param>
        /// <param name="opeResultListener"></param>
        public static void UseActivityCode(string activityId, string activityCode, OpeResultListener opeResultListener)
        {

            using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
            {
                javaClass.CallStatic("useActivityCode", activityId, activityCode, opeResultListener);
            }
        }

        /// <summary>
        /// 打开礼包详情页
        /// </summary>
        /// <param name="giftId"></param>
        public static void OpenGiftDetailById(string giftId)
        {
            UnityAndroid.RunOnUiThread(new AndroidJavaRunnable(() =>
            {
                using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
                {
                    javaClass.CallStatic("openGiftDetailById", UnityAndroid.GetUnityActivity(), giftId);
                }
            }));
        }

        /// <summary>
        /// 使用礼包码
        /// </summary>
        /// <param name="giftId"></param>
        /// <param name="giftCode"></param>
        /// <param name="opeResultListener"></param>
        public static void UseGiftCode(string giftId, string giftCode, OpeResultListener opeResultListener)
        {

            using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
            {
                javaClass.CallStatic("useGiftCode", giftId, giftCode, opeResultListener);
            }
        }

        /// <summary>
        /// 打开游戏圈
        /// </summary>
        public static void OpenGameHub()
        {
            UnityAndroid.RunOnUiThread(() =>
            {
                using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
                {
                    javaClass.CallStatic("openGameHub", UnityAndroid.GetUnityActivity());
                }
            });
        }

        /// <summary>
        /// 礼包是否启用
        /// </summary>
        /// <returns></returns>
        public static bool IsGiftEnabled()
        {
            using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
            {
                return javaClass.CallStatic<bool>("isGiftEnabled");
            }
        }

        /// <summary>
        /// 是否有礼包
        /// </summary>
        /// <returns></returns>
        public static bool IsHasGift()
        {
            using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
            {
                return javaClass.CallStatic<bool>("isHasGift");
            }
        }

        /// <summary>
        /// 活动是否启用
        /// </summary>
        /// <returns></returns>
        public static bool IsActivityEnabled()
        {
            using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
            {
                return javaClass.CallStatic<bool>("isActivityEnabled");
            }
        }

        /// <summary>
        /// 是否有活动
        /// </summary>
        /// <returns></returns>
        public static bool IsHasActivity()
        {
            using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
            {
                return javaClass.CallStatic<bool>("isHasActivity");
            }
        }

        /// <summary>
        /// 游戏圈是否启用
        /// </summary>
        /// <returns></returns>
        public static bool IsGameHubEnabled()
        {
            using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
            {
                return javaClass.CallStatic<bool>("isGameHubEnabled");
            }
        }

        /// <summary>
        /// 打开游戏盒详情页，若没有下载游戏盒则提示下载
        /// </summary>
        public static void OpenGameDetail()
        {
            UnityAndroid.RunOnUiThread(new AndroidJavaRunnable(() =>
            {
                using (var javaClass = new AndroidJavaClass(EXCLUSIVE_AGENT_JAVA_CLASS_NAME))
                {
                    javaClass.CallStatic("openGameDetail", UnityAndroid.GetUnityActivity());
                }
            }));
        }

        public abstract class OnInitGlobalListener : AndroidJavaProxy
        {
            public OnInitGlobalListener() : base("cn.m4399.operate.ExclusiveAgent$OnInitGlobalListener")
            {
            }

            internal void onInitFinished()
            {
                OnInitFinished();
            }

            internal void onActivationState(int code, string msg)
            {
                OnActivationState(code, msg);
            }

            /// <summary>
            /// 初始化完成
            /// </summary>
            protected abstract void OnInitFinished();

            /// <summary>
            /// 激活状态回调
            /// </summary>
            /// <param name="code">0:激活禁用 1:激活成功 2:已激活过</param>
            /// <param name="msg"></param>
            protected abstract void OnActivationState(int code, string msg);
        }
    }
}