﻿using UnityEngine;
using System.Collections;
namespace cn.m4399.operate
{
    public class Archive
    {

        private readonly AndroidJavaObject JavaObject;

        /// <summary>
        /// 存档索引
        /// </summary>
        public int Index { get; }

        /// <summary>
        /// 存档标题
        /// </summary>
        public string Title { get; }

        /// <summary>
        /// 最后更新时间
        /// </summary>
        public int UpdateTime { get; }

        /// <summary>
        /// 存档数据
        /// </summary>
        public string Data { get; }

        internal Archive(AndroidJavaObject javaObject)
        {
            JavaObject = javaObject;
            Index = javaObject.Get<int>("index");
            Title = javaObject.Get<string>("title");
            UpdateTime = javaObject.Get<int>("updateTime");
            Data = javaObject.Get<string>("data");
        }

        /// <summary>
        /// 创建
        /// </summary>
        /// <param name="index">存档索引</param>
        /// <param name="title">存档标题</param>
        /// <param name="data">存档数据</param>
        /// <returns></returns>
        public static Archive Create(int index, string title, string data)
        {
            AndroidJavaObject javaObject;
            using (var javaClass = new AndroidJavaClass("cn.m4399.operate.Archive")) {
                javaObject = javaClass.CallStatic<AndroidJavaObject>("create", index, title, data);
            }
            return new Archive(javaObject);
        }

        internal AndroidJavaObject GetJavaObject()
        {
            return JavaObject;
        }
    }
}