﻿using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using UnityEditor.Android;
using UnityEngine;

namespace cn.m4399.sdk
{
    /// <summary>
    /// 添加ChannelId到AndroidManifest.xml中
    /// 4399 sdk
    /// </summary>
    public abstract class OperateChannelId : IPostGenerateGradleAndroidProject
    {
        /// <summary>
        /// 顺序
        /// </summary>
        public virtual int callbackOrder => 4399;


        /// <summary>
        /// 子类复写这个方法返回ChannelId
        /// </summary>
        /// <returns></returns>
        public abstract string ChannelId();

        public void OnPostGenerateGradleAndroidProject(string path)
        {
            var channelId = ChannelId();
            var androidManifestPath = $"{path}/src/main/AndroidManifest.xml";//AndroidManifest.xml的路径
            Debug.Log($"androidManifestPath:{androidManifestPath}");
            var androidManifestSourceText = File.ReadAllText(androidManifestPath);//读取AndroidManifest.xml内容
            var applicationStartRegex = new Regex($"<application[^>]*>");//application
            var applicationStartMatch = applicationStartRegex.Match(androidManifestSourceText);
            var stringBuilder = new StringBuilder();
            if (applicationStartMatch.Success)
            {
                if (applicationStartMatch.Index > 0)
                {
                    stringBuilder.Append(androidManifestSourceText.Substring(0, applicationStartMatch.Index));
                }
                stringBuilder.Append(applicationStartMatch.Value);
                stringBuilder.Append($"\n        <meta-data android:name=\"FTNN_CHANNEL_ID\" android:value=\"{channelId}\" />");
                if (applicationStartMatch.Index + applicationStartMatch.Length < androidManifestSourceText.Length)
                {
                    stringBuilder.Append(androidManifestSourceText.Substring(applicationStartMatch.Index + applicationStartMatch.Length));
                }
            }
            else
            {
                throw new System.Exception($"找不到Applciaiton标签");
            }
            var androidManifestText = stringBuilder.ToString();
            Debug.Log(androidManifestText);
            File.WriteAllText(androidManifestPath, androidManifestText);//写回AndroidManifest.xml    
        }
    }
}