﻿using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using UnityEditor.Android;
using UnityEngine;

namespace cn.m4399.sdk
{
    /// <summary>
    /// 将AndroidManifest.xml中的Activity exported 修改为android:exported="true"
    /// 4399 sdk
    /// </summary>
    public abstract class AndroidManifestActivityExported : IPostGenerateGradleAndroidProject
    {
        /// <summary>
        /// 顺序
        /// </summary>
        public virtual int callbackOrder => 4399;


        /// <summary>
        /// 子类复写这个方法返回需要修改的Activity的类名
        /// 例如:com.unity3d.player.UnityPlayerActivity
        /// </summary>
        /// <returns></returns>
        public abstract string ActivityClass();

        public void OnPostGenerateGradleAndroidProject(string path)
        {
            var activityClass = ActivityClass();
            var androidManifestPath = $"{path}/src/main/AndroidManifest.xml";//AndroidManifest.xml的路径
            Debug.Log($"androidManifestPath:{androidManifestPath}");
            var androidManifestSourceText = File.ReadAllText(androidManifestPath);//读取AndroidManifest.xml内容
            var scopeRegex = new Regex($"<activity[^>]+?android:name\\s*=\\s*\"{activityClass}\"[^>]*");//定位
            var scopeMatch = scopeRegex.Match(androidManifestSourceText);
            var stringBuilder = new StringBuilder();
            if (scopeMatch.Success)
            {
                if (scopeMatch.Index > 0)
                {
                    stringBuilder.Append(androidManifestSourceText.Substring(0, scopeMatch.Index));
                }
                var exportedRegex = new Regex("android:exported\\s*=\\s*\"[^\"]*\"");
                string replacedScope;
                if (exportedRegex.Match(scopeMatch.Value).Success)
                {
                    replacedScope = exportedRegex.Replace(scopeMatch.Value, "android:exported=\"true\"");
                }
                else
                {
                    replacedScope = scopeMatch.Value + " android:exported=\"true\"";
                }
                stringBuilder.Append(replacedScope);
                if (scopeMatch.Index + scopeMatch.Length < androidManifestSourceText.Length)
                {
                    stringBuilder.Append(androidManifestSourceText.Substring(scopeMatch.Index + scopeMatch.Length));
                }
            }
            else
            {
                throw new System.Exception($"找不到Activity:{activityClass}");
            }
            var androidManifestText = stringBuilder.ToString();
            File.WriteAllText(androidManifestPath, androidManifestText);//写回AndroidManifest.xml    
        }
    }
}