﻿using UnityEngine;
using System.Collections.Generic;

namespace cn.m4399.operate.api
{
    public class FriendshipModel
    {
        private AndroidJavaObject JavaObject;

        internal FriendshipModel(AndroidJavaObject javaObject)
        {
            JavaObject = javaObject;
        }

        /// <summary>
        /// 关注列表或者互关列表
        /// </summary>
        /// <returns></returns>
        public List<Follow> GetFollowsList()
        {
            AndroidJavaObject followsJavaObject = JavaObject.Get<AndroidJavaObject>("follows");
            var followsList = new List<Follow>();
            var size = followsJavaObject.Call<int>("size");
            for (var i = 0; i < size; ++ i)
            {
                var followJavaObject = followsJavaObject.Call<AndroidJavaObject>("get", i);
                var follow = new Follow(followJavaObject);
                followsList.Add(follow);
            }
            return followsList;
        }

        /// <summary>
        /// 粉丝列表
        /// </summary>
        /// <returns></returns>
        public List<Follower> GetFollowersList()
        {
            AndroidJavaObject followersJavaObject = JavaObject.Get<AndroidJavaObject>("followers");
            var followersList = new List<Follower>();
            var size = followersJavaObject.Call<int>("size");
            for (var i = 0; i < size; ++ i)
            {
                var followerJavaObject = followersJavaObject.Call<AndroidJavaObject>("get", i);
                var follower = new Follower(followerJavaObject);
                followersList.Add(follower);
            }
            return followersList;
        }

        /// <summary>
        /// 黑名单列表
        /// </summary>
        /// <returns></returns>
        public List<Person> GetPersonList()
        {
            AndroidJavaObject blackListJavaObject = JavaObject.Get<AndroidJavaObject>("blackLists");
            var blackList = new List<Person>();
            var size = blackListJavaObject.Call<int>("size");
            for (var i = 0; i < size; ++ i)
            {
                var personJavaObject = blackListJavaObject.Call<AndroidJavaObject>("get", i);
                var person = new Person(personJavaObject);
                blackList.Add(person);
            }
            return blackList;
        }

        /// <summary>
        /// 搜索结果列表
        /// </summary>
        /// <returns></returns>
        public List<Search> GetSearchList()
        {
            AndroidJavaObject searchListJavaObject = JavaObject.Get<AndroidJavaObject>("searchList");
            var searchList = new List<Search>();
            var size = searchListJavaObject.Call<int>("size");
            for (var i = 0; i < size; ++ i)
            {
                var searchJavaObject = searchListJavaObject.Call<AndroidJavaObject>("get", i);
                var search = new Search(searchJavaObject);
                searchList.Add(search);
            }
            return searchList;
        }

        /// <summary>
        /// 列表里的数据总数
        /// </summary>
        /// <returns></returns>
        public int GetCount()
        {
            return JavaObject.Get<int>("count");
        }

        /// <summary>
        /// 是否有更多 0 否 1 是
        /// </summary>
        /// <returns></returns>
        public bool More()
        {
            return JavaObject.Get<bool>("more");
        }

        public class Person
        {
            private AndroidJavaObject personJavaObject;

            internal Person(AndroidJavaObject javaObject)
            {
                personJavaObject = javaObject;
            }

            /// <summary>
            /// 用户uid
            /// </summary>
            /// <returns></returns>
            public string GetPtUid()
            {
                return personJavaObject.Get<string>("ptUid");
            }

            /// <summary>
            /// 昵称
            /// </summary>
            /// <returns></returns>
            public string GetNick()
            {
                return personJavaObject.Get<string>("nick");
            }

            /// <summary>
            /// 头像
            /// </summary>
            /// <returns></returns>
            public string GetSFace()
            {
                return personJavaObject.Get<string>("sFace");
            }
        }

        public class Search
        {
            private AndroidJavaObject searchJavaObject;

            internal Search(AndroidJavaObject javaObject)
            {
                searchJavaObject = javaObject;
            }

            /// <summary>
            /// 好友关系 1 我关注他 2 他关注我 3=2+1 互关 -1 自己 0 互不关注
            /// </summary>
            /// <returns></returns>
            public int GetRela()
            {
                return searchJavaObject.Get<int>("rela");
            }
        }

        public class Follower
        {
            private AndroidJavaObject followerJavaObject;

            internal Follower(AndroidJavaObject javaObject)
            {
                followerJavaObject = javaObject;
            }

            /// <summary>
            /// 是否互关 0 否 1 是
            /// </summary>
            /// <returns></returns>
            public bool GetIsFriend()
            {
                return followerJavaObject.Get<bool>("isFriend");
            }

            /// <summary>
            /// 头像更新时间
            /// </summary>
            /// <returns></returns>
            public string GetFacetime()
            {
                return followerJavaObject.Get<string>("facetime");
            }
        }

        public class Follow
        {
            private AndroidJavaObject followJavaObject;

            internal Follow(AndroidJavaObject javaObject)
            {
                followJavaObject = javaObject;
            }

            /// <summary>
            /// 是否互关 0 否 1 是
            /// </summary>
            /// <returns></returns>
            public bool GetIsFriend()
            {
                return followJavaObject.Get<bool>("isFriend");
            }

            /// <summary>
            /// 新增时间
            /// </summary>
            /// <returns></returns>
            public string GetDateline()
            {
                return followJavaObject.Get<string>("dateline");
            }

            /// <summary>
            /// 头像更新时间
            /// </summary>
            /// <returns></returns>
            public string GetFacetime()
            {
                return followJavaObject.Get<string>("facetime");
            }
        }
    }
}
