﻿using UnityEngine;

namespace cn.m4399.operate.api
{
    public class ChartDescriptor
    {
        private AndroidJavaObject JavaObject;

        internal ChartDescriptor(AndroidJavaObject javaObject)
        {
            JavaObject = javaObject;
        }

        /// <summary>
        /// 排行榜ID
        /// </summary>
        /// <returns></returns>
        public string GetRankId()
        {
            return JavaObject.Get<string>("rankId");
        }

        /// <summary>
        /// 排行榜名称
        /// </summary>
        /// <returns></returns>
        public string GetRankName()
        {
            return JavaObject.Get<string>("rankName");
        }

        /// <summary>
        /// 游戏key
        /// </summary>
        /// <returns></returns>
        public string GetGameKey()
        {
            return JavaObject.Get<string>("gameKey");
        }

        /// <summary>
        /// 排行周期
        /// </summary>
        /// <returns></returns>
        public string GetInterval()
        {
            return JavaObject.Get<string>("interval");
        }

        /// <summary>
        /// 排行策略
        /// </summary>
        /// <returns></returns>
        public string GetStrategy()
        {
            return JavaObject.Get<string>("strategy");
        }

        /// <summary>
        /// 排行顺序
        /// </summary>
        /// <returns></returns>
        public string GetOrder()
        {
            return JavaObject.Get<string>("order");
        }

        /// <summary>
        /// 当前版本
        /// </summary>
        /// <returns></returns>
        public string GetVersion()
        {
            return JavaObject.Get<string>("version");
        }

        /// <summary>
        /// 是否维护，1为维护中
        /// </summary>
        /// <returns></returns>
        public string GetMaintain()
        {
            return JavaObject.Get<string>("maintain");
        }

        /// <summary>
        /// 排行榜过期时间
        /// </summary>
        /// <returns></returns>
        public string GetExpiredAt()
        {
            return JavaObject.Get<string>("expiredAt");
        }

        /// <summary>
        /// 排行榜激活时间
        /// </summary>
        /// <returns></returns>
        public string GetActivatedAt()
        {
            return JavaObject.Get<string>("activatedAt");
        }
    }
}
