﻿using UnityEngine;

namespace cn.m4399.operate
{
    public class User
    {
        private AndroidJavaObject JavaObject;

        internal User(AndroidJavaObject javaObject)
        {
            JavaObject = javaObject;
        }

        /// <summary>
        /// uid
        /// </summary>
        /// <returns></returns>
        public string GetUid()
        {
            return JavaObject.Call<string>("getUid");
        }

        /// <summary>
        /// 用户名
        /// </summary>
        /// <returns></returns>
        public string GetName()
        {
            return JavaObject.Call<string>("getName");
        }

        /// <summary>
        /// 昵称
        /// </summary>
        /// <returns></returns>
        public string GetNick()
        {
            return JavaObject.Call<string>("getNick");
        }

        /// <summary>
        /// 登录状态
        /// </summary>
        /// <returns></returns>
        public string GetState()
        {
            return JavaObject.Call<string>("getState");
        }

        /// <summary>
        /// 是否激活
        /// </summary>
        /// <returns></returns>
        public bool IsActivated()
        {
            return JavaObject.Call<bool>("isActivated");
        }

        /// <summary>
        /// 绑定的手机号，已脱敏，若已绑定则此字段非空
        /// </summary>
        /// <returns></returns>
        public string GetPhone()
        {
            return JavaObject.Call<string>("getPhone");
        }

        /// <summary>
        /// 获取 vip 状态
        /// </summary>
        /// <returns>0没有VIP  1有VIP但是不弹窗  2有VIP并且弹窗</returns>
        public int GetVipState()
        {
            return JavaObject.Call<int>("getVipState");
        }

        /// <summary>
        /// 获取实名状态
        /// </summary>
        /// <returns>
        /// v2.30.0.28及之前版本， 0 未实名，1 小于8岁，2 小于18岁，3、4 18岁及以上; 
        /// v2.30.0.28之后版本， 0 未实名，1 小于8岁，2 8-15岁，3、4 18岁及以上，5 16-17岁; 其他值无效
        /// </returns>
        public int GetIdCardState()
        {
            return JavaObject.Call<int>("getIdCardState");
        }

        /// <summary>
        /// 是否通过实名认证
        /// </summary>
        /// <returns></returns>
        public bool IsIdCheckedReal()
        {
            return JavaObject.Call<bool>("isIdCheckedReal");
        }

        /// <summary>
        /// IsIdCardEditable
        /// </summary>
        /// <returns></returns>
        public bool IsIdCardEditable()
        {
            return JavaObject.Call<bool>("isIdCardEditable");
        }

        public override string ToString()
        {
            return $"{GetUid()} {GetName()} {GetNick()} {GetState()}";
        }
    }
}
