﻿using UnityEngine;

namespace cn.m4399.operate
{
    public class OperateConfig
    {
        private readonly AndroidJavaObject JavaObejct;

        private OperateConfig(AndroidJavaObject javaObject)
        {
            JavaObejct = javaObject;
        }

        internal AndroidJavaObject GetJavaObject()
        {
            return JavaObejct;
        }

        public class Builder
        {
            private readonly AndroidJavaObject JavaObejct;

            public Builder()
            {
                JavaObejct = new AndroidJavaObject("cn.m4399.operate.OperateConfig$Builder", UnityAndroid.GetUnityActivity());
            }

            public Builder SetGameKey(string gameKey)
            {
                JavaObejct.Call<AndroidJavaObject>("setGameKey", gameKey);
                return this;
            }

            public Builder SetDebugEnabled(bool enabled)
            {
                JavaObejct.Call<AndroidJavaObject>("setDebugEnabled", enabled);
                return this;
            }

            public Builder SetOrientation(int orientation)
            {
                JavaObejct.Call<AndroidJavaObject>("setOrientation", orientation);
                return this;
            }

            public Builder CompatNotch(bool b)
            {
                JavaObejct.Call<AndroidJavaObject>("compatNotch", b);
                return this;
            }

            public Builder SetPopLogoStyle(PopLogoStyle popLogoStyle)
            {
                using (var enumJavaClass = new AndroidJavaClass("cn.m4399.operate.OperateConfig$PopLogoStyle")) {
                    var enumJava = enumJavaClass.GetStatic<AndroidJavaObject>(popLogoStyle.ToString());
                    JavaObejct.Call<AndroidJavaObject>("setPopLogoStyle", enumJava);
                }
                return this;
            }

            public Builder SetPopWinPosition(PopWinPosition popWinPosition)
            {
                using (var enumJavaClass = new AndroidJavaClass("cn.m4399.operate.OperateConfig$PopWinPosition"))
                {
                    var enumJava = enumJavaClass.GetStatic<AndroidJavaObject>(popWinPosition.ToString());
                    JavaObejct.Call<AndroidJavaObject>("setPopWinPosition", enumJava);
                }
                return this;
            }

            public OperateConfig Build()
            {
                var javaObject = JavaObejct.Call<AndroidJavaObject>("build");
                return new OperateConfig(javaObject);
            }
        }

        public enum PopLogoStyle
        {
            POPLOGOSTYLE_ONE,
            POPLOGOSTYLE_TWO,
            POPLOGOSTYLE_THREE,
            POPLOGOSTYLE_FOUR
        }

        public enum PopWinPosition
        {
            POS_LEFT,
            POS_BOTTOM,
            POS_RIGHT,
            POS_TOP
        }
    }

}
