﻿using System.Threading;
using UnityEngine;

namespace cn.m4399.operate
{
    public class FixBlackScreenHelper
    {

        private static int Executed = 0;

        public static void FixBlackScreen()
        {
            if (Interlocked.Exchange(ref Executed, 1) == 0)
            {
                UnityAndroid.GetApplication().Call("registerActivityLifecycleCallbacks", new FixBlackScreenActivityLifecycleCallbacks());
            }
        }

        private class FixBlackScreenActivityLifecycleCallbacks : AndroidJavaProxy
        {
            public FixBlackScreenActivityLifecycleCallbacks() : base("android.app.Application$ActivityLifecycleCallbacks")
            {
            }

            internal void onActivityCreated(AndroidJavaObject activity, AndroidJavaObject savedInstanceState)
            {

            }

            internal void onActivityStarted(AndroidJavaObject activity)
            {
                AndroidJavaObject unityActivity = UnityAndroid.GetUnityActivity();
                if (activity.Call<bool>("equals", unityActivity))
                {
                    AndroidJavaObject unityPlayer = activity.Get<AndroidJavaObject>("mUnityPlayer");
                    unityPlayer.Call("resume");
                    unityPlayer.Call("windowFocusChanged", true);
                }
            }

            internal void onActivityResumed(AndroidJavaObject activity)
            {
                
            }

            internal void onActivityPaused(AndroidJavaObject activity)
            {

            }

            internal void onActivityStopped(AndroidJavaObject activity)
            {

            }

            internal void onActivitySaveInstanceState(AndroidJavaObject activity, AndroidJavaObject outState)
            {

            }

            internal void onActivityDestroyed(AndroidJavaObject activity)
            {

            }
        }
    }
}