using cn.m4399.operate;
using cn.m4399.operate.api;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using static cn.m4399.operate.OperateCenter;
using static cn.m4399.operate.api.Achievement;
using static cn.m4399.operate.api.GameChart;
using static cn.m4399.operate.api.Friendship;
using static cn.m4399.operate.api.FriendshipModel;

public class OperateUnityDemo : MonoBehaviour
{
    private const string TAG = "【OperateUnityDemo】";

    private const string GAME_KEY = "40001";
    private const string PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\r\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0ipv8kMdMMNl7efW0HM0\r\nMcCm4cwdDkns/U8eTK02l1TU9iZjGcB0/vYVmUxNUQMQTJb/lnD233r+d7VygSEF\r\nyoHf0TyTcu46kpYX+KrHeaHq+9r2H3oF2MpWtMUADmi3WBazNzOS3j3bDo9Y2lWZ\r\nP1X2CL78yFwwWDpB3ZShoi5xEYTiolEm/bpRKSTYY40DJDx+cv7j2C3nTqDhz3Gu\r\nDjh7GN/j6C6PJkm4n0er73+uAhCnMDmQmXcidg7aSeFIzADp3+WO100ViCb3apcW\r\nmZZRQk9z7RKuVcu3UoVeyJNL3xML0S56GW+cCtiJ9RpTSXoby70CLPolGTyB4mIZ\r\nrQIDAQAB\r\n-----END PUBLIC KEY-----";
    private const string SERVER_ID = "1";
    private const string ROLE_ID = "1";
    private static OperateCenter Ope;
    ///成就列表
    private static List<AchievementDetail> achList;
    ///排行榜列表
    private static List<ChartDescriptor> chdList;
    private static PtUser ptUser;

    private void Awake()
    {
        InitSDK();
        InitAchievement();
        InitGameChart();
        GameObject.Find("BtnLogin").GetComponent<Button>().onClick.AddListener(DoLogin);
        GameObject.Find("BtnSwitchAccount").GetComponent<Button>().onClick.AddListener(DoSwitchAccount);
        GameObject.Find("BtnSetServer").GetComponent<Button>().onClick.AddListener(DoSetServer);
        GameObject.Find("BtnLogout").GetComponent<Button>().onClick.AddListener(DoLogout);
        GameObject.Find("BtnGetCurrentAccount").GetComponent<Button>().onClick.AddListener(DoGetCurrentAccount);
        GameObject.Find("BtnIsLogin").GetComponent<Button>().onClick.AddListener(DoIsLogin);
        GameObject.Find("BtnRecharge").GetComponent<Button>().onClick.AddListener(DoRecharge);
        GameObject.Find("BtnGetVersion").GetComponent<Button>().onClick.AddListener(DoGetVersion);
        GameObject.Find("BtnGetMyself").GetComponent<Button>().onClick.AddListener(DoGetMyself);
        GameObject.Find("BtnGetFriendshipList").GetComponent<Button>().onClick.AddListener(DoGetFriendshipList);
        GameObject.Find("BtnFollow").GetComponent<Button>().onClick.AddListener(DoFollow);
        GameObject.Find("BtnUnFollow").GetComponent<Button>().onClick.AddListener(DoUnfollow);
        GameObject.Find("BtnSearch").GetComponent<Button>().onClick.AddListener(DoSearch);
        GameObject.Find("BtnInvite").GetComponent<Button>().onClick.AddListener(DoInvite);
        GameObject.Find("BtnGetGameAchievement").GetComponent<Button>().onClick.AddListener(DoGetGameAchievement);
        GameObject.Find("BtnGetPersonalAchievement").GetComponent<Button>().onClick.AddListener(DoGetPersonalAchievement);
        GameObject.Find("BtnUpdateAchievement").GetComponent<Button>().onClick.AddListener(DoUpdateAchievement);
        GameObject.Find("BtnGetGameChart").GetComponent<Button>().onClick.AddListener(DoGetGameChart);
        GameObject.Find("BtnGetChartByRange").GetComponent<Button>().onClick.AddListener(DoGetChartByRange);
        GameObject.Find("BtnGetChartAroundRole").GetComponent<Button>().onClick.AddListener(DoGetChartAroundRole);
        GameObject.Find("BtnUpdateChartByUser").GetComponent<Button>().onClick.AddListener(DoUpdateChartByUser);
        GameObject.Find("BtnGetPtUser").GetComponent<Button>().onClick.AddListener(DoGetPtUser);
    }

    private void Update()
    {
        if (Input.GetKeyDown(KeyCode.Escape))
        {
            Ope.ShouldQuitGame(new DemoCommons.OnQuitGameListenerImpl());
        }
    }

    //检测空格
    private bool IsSpace(string textValue)
    {
        if (textValue.Trim().Length == 0)//去掉字符串头尾的空格
        {
            return true;
        }
        return false;
    }

    private void InitSDK()
    {
        Ope = OperateCenter.GetInstance();
        var operateConfig = new OperateConfig.Builder()
                .SetGameKey(GAME_KEY)
                .SetDebugEnabled(false)
                .SetOrientation(0)
                .SetPopLogoStyle(OperateConfig.PopLogoStyle.POPLOGOSTYLE_ONE)
                .SetPopWinPosition(OperateConfig.PopWinPosition.POS_TOP)
                .CompatNotch(true)
                .Build();
        Ope.SetConfig(operateConfig);
        Ope.gameProtocol(operateConfig,new GameProtocolResultListener());
        FixBlackScreenHelper.FixBlackScreen();
    }

    private void InitAchievement()
    {
        Achievement.Init(PUBLIC_KEY);
    }

    private void InitGameChart()
    {
        GameChart.Init(PUBLIC_KEY);
    }

    private void DoLogin()
    {
        Ope.Login(new OnLoginFinishedListenerImpl());
    }

    private void DoSwitchAccount()
    {
        Ope.SwitchAccount(new OnLoginFinishedListenerImpl());
    }

    private void DoSetServer()
    {
        var serverId = "1";
        Ope.SetServer(serverId);
    }

    private void DoLogout()
    {
        Ope.Logout();
    }

    private void DoGetCurrentAccount()
    {
        var user = Ope.GetCurrentAccount();
        ToastAndLog($"user:{user}");
    }

    private void DoIsLogin()
    {
        var isLogin = Ope.IsLogin();
        ToastAndLog($"isLogin:{isLogin}");
    }

    private void DoRecharge()
    {
        int money = 1;
        string mark = "1";
        string commodity = "test";
        Ope.Recharge(money, mark, commodity, new OnRechargeFinishedListenerImpl());
    }

    private void DoGetVersion()
    {
        var version = OperateCenter.GetVersion();
        ToastAndLog($"version:{version}");
    }

    class GameProtocolResultListener : OpeResultListener
    {
        protected override void OnResult(int code, string msg)
        {
            ToastAndLog($"{code} : {msg}");

            Ope.Init(new OnInitGlobalListenerImpl());
        }
    }

    private void DoGetMyself()
    {
        Friendship.GetMyself(new OpeDataPersonListenerImpl());
    }

    private void DoGetFriendshipList()
    {
        int type = Friendship.FOLLOW;///Friendship.FOLLOW, Friendship.FOLLOWER, Friendship.MUTUAL, Friendship.BLACK
        int page = 1;///页数，默认为1，
        Friendship.List(type, page, new OpeDataFriendshipModelListenerImpl());
    }

    private void DoFollow()
    {
        string uids = "123456789";
        string ip_uids = GameObject.Find("IpUids").GetComponent<InputField>().text;
        if (!IsSpace(ip_uids))
        {
            uids = ip_uids;
        }
        Friendship.Follow(uids, new OpeDataSimpleListenerImpl());
    }

    private void DoUnfollow()
    {
        string uid = "123456789";
        string ip_uid = GameObject.Find("IpUids").GetComponent<InputField>().text;
        if (!IsSpace(ip_uid))
        {
            uid = ip_uid;
        }
        Friendship.Unfollow(uid, new OpeDataSimpleListenerImpl());
    }

    private void DoSearch()
    {
        string uid = "123456789";
        string ip_uid = GameObject.Find("IpUids").GetComponent<InputField>().text;
        if (!IsSpace(ip_uid))
        {
            uid = ip_uid;
        }
        Friendship.Search(uid, new OpeDataFriendshipModelListenerImpl());
    }

    private void DoInvite()
    {
        string uid = "123456789";
        string ip_uid = GameObject.Find("IpUids").GetComponent<InputField>().text;
        if (!IsSpace(ip_uid))
        {
            uid = ip_uid;
        }
        Friendship.Invite(uid, new OpeDataSimpleListenerImpl());
    }

    private void DoGetGameAchievement()
    {
        Achievement.GetGameAchievement(new OpeDataListListenerImpl());
    }

    private void DoGetPersonalAchievement()
    {
        bool isInit = Achievement.IsRoleInit(SERVER_ID, ROLE_ID);
        if (isInit)
        {
            Achievement.GetAchievementList(SERVER_ID, ROLE_ID, new OpeDataListListenerImpl());
        }
        else
        {
            ToastAndLog($"IsRoleInit:{isInit}");
        }
    }

    private void DoUpdateAchievement()
    {
        bool isInit = Achievement.IsRoleInit(SERVER_ID, ROLE_ID);
        if (isInit)
        {
            if (achList != null && achList.ToArray().Length > 0)
            {
                UpdateMode model = Achievement.UpdateMode.UPDATE_ADD;
                string id = achList[0].GetId();
                int step = 1;
                Achievement.UpdateAchievement(SERVER_ID, ROLE_ID, model, id, step, new OpeDataListenerImpl());
            }
            else
            {
                ToastAndLog($"achList:null");
            }
        }
        else
        {
            ToastAndLog($"IsRoleInit:{isInit}");
        }
    }

    private void DoGetGameChart()
    {
        GameChart.GetGameChart(new OpeDataChartDescriptorListListenerImpl());
    }

    private void DoGetChartByRange()
    {
        if (chdList != null && chdList.ToArray().Length > 0)
        {
            string rankId = chdList[0].GetRankId();
            int start = 0;
            int end = 10;
            GameChart.GetChartByRange(rankId, int.Parse(SERVER_ID), start, end, new OpeDataChartItemListListenerImpl());
        }
        else
        {
            ToastAndLog($"chdList:null");
        }
    }

    private void DoGetChartAroundRole()
    {
        if (chdList != null && chdList.ToArray().Length > 0)
        {
            string rankId = chdList[0].GetRankId();
            int before = 0;
            int after = 10;
            GameChart.GetChartAroundRole(rankId, int.Parse(SERVER_ID), ROLE_ID, before, after, new OpeDataChartItemListListenerImpl());
        }
        else
        {
            ToastAndLog($"chdList:null");
        }
    }

    private void DoUpdateChartByUser()
    {
        if (chdList != null && chdList.ToArray().Length > 0)
        {
            if (ptUser != null)
            {
                string rankId = chdList[0].GetRankId();
                float score = 100.0f;
                GameChart.UpdateByRole(rankId, int.Parse(SERVER_ID), ROLE_ID, ptUser.GetAvatar(), ptUser.GetNick(), score, new OpeDataUpdateChartListenerImpl());
            }
            else
            {
                ToastAndLog($"ptUser:null");
            }
        }
        else
        {
            ToastAndLog($"chdList:null");
        }
    }

    private void DoGetPtUser()
    {
        GameChart.getPtUser(new OpeDataGetPtUserListenerImpl());
    }

    class OnInitGlobalListenerImpl : OnInitGlobalListener
    {
        protected override void OnInitFinished(bool isLogin, User user)
        {
            ToastAndLog($"OnInitFinished isLogin:{isLogin} user:{user}");
            if (isLogin)
            {
                Achievement.InitRole(SERVER_ID, ROLE_ID, new OpeDataListenerImpl());
            }
        }

        protected override void OnSwitchUserAccountFinished(bool fromUserCenter, User user)
        {
            ToastAndLog($"OnSwitchUserAccountFinished fromUserCenter:{fromUserCenter} user:{user}");
        }

        protected override void OnUserAccountLogout(bool fromUserCenter)
        {
            ToastAndLog($"OnUserAccountLogout fromUserCenter:{fromUserCenter}");
        }
    }

    class OnLoginFinishedListenerImpl : OnLoginFinishedListener
    {
        protected override void OnLoginFinished(bool success, int resultCode, User user)
        {
            ToastAndLog($"OnLoginFinished success:{success} resultCode:{resultCode} user:{user}");
            if (success)
            {
                Achievement.InitRole(SERVER_ID, ROLE_ID, new OpeDataListenerImpl());
            }
        }
    }

    class OnRechargeFinishedListenerImpl : OnRechargeFinishedListener
    {
        protected override void OnRechargeFinished(bool success, int resultCode, string msg)
        {
            ToastAndLog($"OnRechargeFinished success:{success} resultCode:{resultCode} msg:{msg}");
        }
    }

    class OpeDataPersonListenerImpl : OpeDataFriendshipListener
    {
        protected override void OnFinished(int resultCode, string msg, AndroidJavaObject androidJavaObject)
        {
            Person person = new Person(androidJavaObject);
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} person.uid:{person.GetPtUid()} person.nick:{person.GetNick()} person.sFace:{person.GetSFace()}");
        }
    }

    class OpeDataFriendshipModelListenerImpl : OpeDataFriendshipListener
    {
        protected override void OnFinished(int resultCode, string msg, AndroidJavaObject androidJavaObject)
        {
            FriendshipModel friendshipModel = new FriendshipModel(androidJavaObject);
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} friendshipModel.count:{friendshipModel.GetCount()} friendshipModel.more:{friendshipModel.More()}");
        }
    }

    class OpeDataSimpleListenerImpl : OpeDataFriendshipListener
    {
        protected override void OnFinished(int resultCode, string msg, AndroidJavaObject androidJavaObject)
        {
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode}");
        }
    }

    class OpeDataListenerImpl : OpeDataListener
    {
        protected override void OnFinished(int resultCode, string msg, AndroidJavaObject androidJavaObject)
        {
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} androidJavaObject:{androidJavaObject}");
        }
    }

    class OpeDataListListenerImpl : OpeDataListListener
    {
        protected override void OnFinished(int resultCode, string msg, List<AchievementDetail> achievementList)
        {
            string achievementStr = "";
            string achieveTime = "";
            if (achievementList != null)
            {
                achList = achievementList;
                foreach (AchievementDetail a in achievementList)
                {
                    achievementStr += a.GetName() + ",";
                    var personal = a.GetPersonalAchieve();
                    if (personal != null)
                    {
                        achieveTime += personal.GetAchieveTime() + ",";
                    }
                }
            }
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} achievementList:{achievementStr}");
            ToastAndLog($"onFinished achieveTime:{achieveTime}");
        }
    }

    class OpeDataChartDescriptorListListenerImpl : OpeDataChartDescriptorListListener
    {
        protected override void OnFinished(int resultCode, string msg, List<ChartDescriptor> chartDescriptorList)
        {
            string chartDescriptorStr = "";
            if (chartDescriptorList != null)
            {
                chdList = chartDescriptorList;
                foreach (ChartDescriptor c in chartDescriptorList)
                {
                    chartDescriptorStr += c.GetRankName() + ",";
                }
            }
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} chartDescriptorList:{chartDescriptorStr}");
        }
    }

    class OpeDataChartItemListListenerImpl : OpeDataChartItemListListener
    {
        protected override void OnFinished(int resultCode, string msg, List<ChartItem> chartItemList)
        {
            string chartItemStr = "";
            if (chartItemList != null)
            {
                int i = 0;
                foreach (ChartItem c in chartItemList)
                {
                    i++;
                    chartItemStr += i + "." + c.GetRoleId() + ",";
                }
            }
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} chartItemList:{chartItemStr}");
        }
    }

    class OpeDataGetPtUserListenerImpl : OpeDataPtUserListener
    {
        protected override void OnFinished(int resultCode, string msg, AndroidJavaObject androidJavaObject)
        {
            if (androidJavaObject != null)
            {
                ptUser = new PtUser(androidJavaObject);
            }
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} ptUser:{ptUser.GetNick()},{ptUser.GetAvatar()}");
        }
    }

    class OpeDataUpdateChartListenerImpl : OpeDataUpdateChartListener
    {
        protected override void OnFinished(int resultCode, string msg, bool success)
        {
            ToastAndLog($"onFinished msg:{msg} resultCode:{resultCode} success:{success}");
        }
    }

    static void ToastAndLog(string s)
    {
        DemoCommons.ToastAndLog(TAG, s);
    }
}
