﻿using UnityEngine;
using cn.m4399.operate;
using UnityEngine.UI;
using UnityEngine.Android;
using UnityEngine.SceneManagement;

public class EaUnityDemo : MonoBehaviour
{
    private const string TAG = "【EaUnityDemo】";

    private const string GAME_KEY = "70001";

    private static bool InitedSDK = false;

    private static bool GameProAlready = false;

    private OperateCenter Ope;

    private static OperateConfig OpeConfig;

    private static bool RequestedPermission = false;//请求过权限，但是用户不一定有授权

    private void Awake()
    {
        GameObject.Find("BtnOpenActivityDetail").GetComponent<Button>().onClick.AddListener(DoOpenActivityDetail);
        GameObject.Find("BtnUseActivityCode").GetComponent<Button>().onClick.AddListener(DoUseActivityCode);
        GameObject.Find("BtnOpenGiftDetail").GetComponent<Button>().onClick.AddListener(DoOpenGiftDetail);
        GameObject.Find("BtnUseGiftCode").GetComponent<Button>().onClick.AddListener(DoUseGiftCode);
        GameObject.Find("BtnGameHub").GetComponent<Button>().onClick.AddListener(DoOpenGameHub);
        GameObject.Find("BtnGameDetail").GetComponent<Button>().onClick.AddListener(DoOpenGameDetail);
        GameObject.Find("BtnOperateAction").GetComponent<Button>().onClick.AddListener(DoOperateAction);
        GameObject.Find("BtnShare").GetComponent<Button>().onClick.AddListener(DoShare);
        GameObject.Find("BtnComment").GetComponent<Button>().onClick.AddListener(DoComment);
        GameObject.Find("BtnCloudArchive").GetComponent<Button>().onClick.AddListener(DoCloudArchive);
//        GameProtocol();
        FixBlackScreenHelper.FixBlackScreen();
    }

    private void Update()
    {
        if (Input.GetKeyDown(KeyCode.Escape))
        {
            OperateCenter.GetInstance().ShouldQuitGame(new DemoCommons.OnQuitGameListenerImpl());
        }
    }

    private void OnApplicationFocus(bool focus)
    {
        //如果您的Unity版本支持Android.PermissionCallbacks，则不需要这种方式
        if (focus && !GameProAlready)
        {
            GameProtocol();
        }
        else if (focus && !InitedSDK)
        {
            InitSDK();
        }
    }

    private static void InitSDK()
    {
        if (RequestedPermission || Permission.HasUserAuthorizedPermission(Permission.ExternalStorageWrite))
        {
            //ToastAndLog("注意！已授予储存权限!");
            ExclusiveAgent.Init(OpeConfig, new InitListener());
            InitedSDK = true;
        }
        else
        {
            RequestedPermission = true;
            ToastAndLog("请授予储存权限!");
            //这里应该给个权限提示，使用对话框最佳
            Permission.RequestUserPermission(Permission.ExternalStorageWrite);
            //Permission.RequestUserPermission(Permission.ExternalStorageWrite, permissionCallbacks);如果您的Unity版本支持Android.PermissionCallbacks
        }
    }

    private void GameProtocol()
    {
        OpeConfig = new OperateConfig.Builder()
            .SetGameKey(GAME_KEY)
            .SetDebugEnabled(false)
            .SetOrientation(0)
            .SetPopLogoStyle(OperateConfig.PopLogoStyle.POPLOGOSTYLE_ONE)
            .SetPopWinPosition(OperateConfig.PopWinPosition.POS_TOP)
            .CompatNotch(true)
            .Build();
        Ope = OperateCenter.GetInstance();
        Ope.gameProtocol(OpeConfig,new GameProtocolResultListener());
    }


    class GameProtocolResultListener : OpeResultListener
    {
        protected override void OnResult(int code, string msg)
        {
            ToastAndLog($"{code} : {msg}");
            GameProAlready = true;
            InitSDK();
        }
    }

    class InitListener : ExclusiveAgent.OnInitGlobalListener
    {
        protected override void OnActivationState(int code, string msg)
        {
            ToastAndLog($"{code} : {msg}");
        }

        protected override void OnInitFinished()
        {
            ToastAndLog("初始化完成");
        }
    }

    public void DoOpenActivityDetail()
    {
        var activityDetailKey = GameObject.Find("IpfActivityDetailKey").GetComponent<InputField>().text;
        Action(activityDetailKey);
    }

    public void DoOpenGiftDetail()
    {
        var giftDetailKey = GameObject.Find("IpfGiftDetailKey").GetComponent<InputField>().text;
        Action(giftDetailKey);
    }

    public void DoOpenGameHub()
    {
        var gameHubKey = "51nfesTWNwVSYhXfxd1";
        Action(gameHubKey);
    }

    public void DoOpenGameDetail()
    {
        var gameDetailKey = "51nnEXdiUzpcsmbdgH2";
        Action(gameDetailKey);
    }

    public void DoUseActivityCode()
    {
        var useActivityId = GameObject.Find("IpfUseActivityId").GetComponent<InputField>().text;
        var useActivityCode = GameObject.Find("IpfUseActivityCode").GetComponent<InputField>().text;
        ExclusiveAgent.UseActivityCode(useActivityId, useActivityCode, new UseActivityCodeListener());
    }

    class UseActivityCodeListener : OpeResultListener
    {
        protected override void OnResult(int code, string message)
        {
            ToastAndLog($"{code} : {message}");
        }
    }

    public void DoUseGiftCode()
    {
        var useGiftId = GameObject.Find("IpfUseGiftId").GetComponent<InputField>().text;
        var useGiftCode = GameObject.Find("IpfUseGiftCode").GetComponent<InputField>().text;
        ExclusiveAgent.UseGiftCode(useGiftId, useGiftCode, new UseGiftCodeListener());
    }

    class UseGiftCodeListener : OpeResultListener
    {
        protected override void OnResult(int code, string message)
        {
            ToastAndLog($"{code} : {message}");
        }
    }

    public void DoOperateAction()
    {
        var key = GameObject.Find("IpfOperateActionKey").GetComponent<InputField>().text;
        Action(key);
    }


    public void Action(string key)
    {
        OperateAction.Support(key, new OperateActionListener(key));
    }

    class OperateActionListener : OpeResultListener
    {
        private readonly string Key;

        public OperateActionListener(string key) : base()
        {
            Key = key;
        }

        protected override void OnResult(int code, string message)
        {
            var ret = OperateAction.Perform(Key);
            ToastAndLog($"{ret} : {message}");
        }
    }

    public void DoShare()
    {
        OperateCenter.GetInstance().Share();
    }

    public void DoComment()
    {
        OperateCenter.GetInstance().Comment();
    }

    public void DoCloudArchive()
	{
        SceneManager.LoadScene("CloudArchiveUnityDemoScene");
    }

    static void ToastAndLog(string s)
    {
        DemoCommons.ToastAndLog(TAG, s);
    }
}
