﻿using UnityEngine;
using cn.m4399.operate;
using System.Collections.Generic;
using UnityEngine.UI;
using System.Text;

public class CloudArhiveUnityDemo : MonoBehaviour
{
    private const string TAG = "【CloudArhiveUnityDemo】";

    private static readonly string PUBLIC_KEY =
@"
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnbghMwvE21bzrbJtU0Sd
ZWhYu0M+qnHvwsS6GR8CFDfTs94Xis5G8P1/kTjPDlBDrCssDdmt7IkFab30EHVX
Dq77TzIHSB84VKpOcOayPR9xC25U4lfeZYo2UZeBbiZCmdBVhQTPxmDYBJtf4JAA
X2Qx8sAsc14u/po0+GZ1Sd89RXYfTehkqdvjzmbA242v8ISb6lodtOjm9mphxhMq
jiOj/06qsiP+76T3ydCse96flqn3qNHQA9X6u2lhRi+MH4VbrZq1wqLoWfAyXs9H
erH0IHujHYEBFiXskiyDtnpNpF028Tfh1HeDxKj6d8rH2BA050TrQR7sq1V0mrac
4QIDAQAB
-----END PUBLIC KEY-----
";
    void Awake()
    {        
        Init();
        GameObject.Find("BtnGet").GetComponent<Button>().onClick.AddListener(Get);
        GameObject.Find("BtnSave").GetComponent<Button>().onClick.AddListener(Save);
        GameObject.Find("BtnList").GetComponent<Button>().onClick.AddListener(List);
    }

    private void Init()
    {
        var initListener = new InitListenerImpl();
        initListener.OnFailureEvent += (code, message) =>
        {
            ToastAndLog($"初始化故障:{code} {message}");
        };
        initListener.OnSuccessEvent += () =>
        {
            ToastAndLog("初始化成功");
        };
        initListener.OnUserChangedEvent += (previousUserCloudArchive, currentUserCloudArchive) =>
        {
            ToastAndLog($"登录用户改变:{previousUserCloudArchive != null} {currentUserCloudArchive != null}");
        };
        CloudArchive.Init(PUBLIC_KEY, initListener);
    }

    private Archive TestArchive()
    {
        return Archive.Create(1, "测试标题1", "测试数据1");
    }

    private static string ArchiveToString(Archive archive)
    {
        return $"index: {archive.Index}, title: {archive.Title}, updateTime: {archive.UpdateTime}, data: {archive.Data}";
    }

    private static string ArchiveListToString(List<Archive> archiveList)
    {
        var stringBuilder = new StringBuilder();
        foreach (var archive in archiveList)
        {
            stringBuilder.Append(ArchiveToString(archive));
            stringBuilder.Append("\n");
        }
        return stringBuilder.ToString();
    }

    private void List(CloudArchive cloudArchive)
    {
        var listListener = new ListListenerImpl();
        listListener.OnFailureEvent += (code, message) =>
        {
            ToastAndLog($"获取存档列表故障:{code} {message}");
        };
        listListener.OnSuccessEvent += (archiveList) =>
        {
           ToastAndLog($"存档列表:{ArchiveListToString(archiveList)}");
        };
        cloudArchive.List(listListener);
    }

    private void List()
    {
        List(CloudArchive.GetCloudArchive());
    }

    private void Save(CloudArchive cloudArchive, Archive archive)
    {
        var saveListener = new SaveListenerImpl();
        saveListener.OnFailureEvent += (code, message) =>
        {
            ToastAndLog($"保存存档故障:{code} {message}");
        };

        saveListener.OnSuccessEvent += () =>
        {
            ToastAndLog("保存存档成功");
        };
        cloudArchive.Save(archive, saveListener);
    }

    private void Save()
    {
        Save(CloudArchive.GetCloudArchive(), TestArchive());
    }

    private void Get(CloudArchive cloudArchive, int index)
    {
        var getListener = new GetListenerImpl();
        getListener.OnFailureEvent += (code, message) =>
        {
            ToastAndLog($"读取存档故障:{code} {message}");
        };
        getListener.OnSuccessEvent += (archive) =>
        {
            ToastAndLog($"存档:{ArchiveToString(archive)}");
        };
        cloudArchive.Get(index, getListener);
    }

    private void Get()
    {
        Get(CloudArchive.GetCloudArchive(), 1);
    }

    static void ToastAndLog(string s)
    {
        DemoCommons.ToastAndLog(TAG, s);
    }


    class InitListenerImpl : CloudArchive.InitListener
    {
        public delegate void OnFailureDelegate(int code, string message);
        public delegate void OnSuccessDelegate();
        public delegate void OnUserChangedDelegate(CloudArchive previousUserCloudArchive, CloudArchive currentUserCloudArchive);

        public event OnFailureDelegate OnFailureEvent;
        public event OnSuccessDelegate OnSuccessEvent;
        public event OnUserChangedDelegate OnUserChangedEvent;

        public InitListenerImpl()
        {
        }

        protected override void OnFailure(int code, string message)
        {
            OnFailureEvent?.Invoke(code, message);
        }

        protected override void OnSuccess()
        {
            OnSuccessEvent?.Invoke();
        }

        protected override void OnUserChanged(CloudArchive previousUserCloudArchive, CloudArchive currentUserCloudArchive)
        {
            OnUserChangedEvent?.Invoke(previousUserCloudArchive, currentUserCloudArchive);
        }
    }

    class ListListenerImpl : CloudArchive.ListListener
    {

        public delegate void OnFailureDelegate(int code, string message);

        public delegate void OnSuccessDelegate(List<Archive> archiveList);

        public event OnFailureDelegate OnFailureEvent;

        public event OnSuccessDelegate OnSuccessEvent;

        protected override void OnFailure(int code, string message)
        {
            OnFailureEvent?.Invoke(code, message);
        }

        protected override void OnSuccess(List<Archive> archiveList)
        {
            OnSuccessEvent?.Invoke(archiveList);
        }
    }

    class GetListenerImpl : CloudArchive.GetListener
    {

        public delegate void OnFailureDelegate(int code, string message);

        public delegate void OnSuccessDelegate(Archive archive);

        public event OnFailureDelegate OnFailureEvent;

        public event OnSuccessDelegate OnSuccessEvent;

        protected override void OnFailure(int code, string message)
        {
            OnFailureEvent?.Invoke(code, message);
        }

        protected override void OnSuccess(Archive archive)
        {
            OnSuccessEvent?.Invoke(archive);
        }
    }

    class SaveListenerImpl : CloudArchive.SaveListener
    {
        public delegate void OnFailureDelegate(int code, string message);

        public delegate void OnSuccessDelegate();

        public event OnFailureDelegate OnFailureEvent;

        public event OnSuccessDelegate OnSuccessEvent;

        protected override void OnFailure(int code, string message)
        {
            OnFailureEvent?.Invoke(code, message);
        }

        protected override void OnSuccess()
        {
            OnSuccessEvent?.Invoke();
        }
    }
}
