﻿using UnityEngine;
using UnityEditor.Android;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace cn.m4399.sdk
{
    public abstract class AndroidGradleRepositories : IPostGenerateGradleAndroidProject
    {
        public virtual int callbackOrder => 4399;


        public abstract List<string> Repositories();

        public void OnPostGenerateGradleAndroidProject(string path)
        {
            var buildGradlePath = $"{path}/build.gradle";//build.gradle的路径
            Debug.Log($"buildGradlePath:{buildGradlePath}");

            var repositories = Repositories();
            if (repositories != null && repositories.Count > 0)
            {
                var repositoriesStringBuilder = new StringBuilder();
                repositoriesStringBuilder.AppendLine();
                repositoriesStringBuilder.AppendLine("rootProject.allprojects {");
                repositoriesStringBuilder.AppendLine("    repositories {");
                //插入的dependencies内容
                foreach (var repositorie in repositories)
                {
                    repositoriesStringBuilder.AppendLine("        maven {");
                    repositoriesStringBuilder.AppendLine($"            url '{repositorie}'");
                    repositoriesStringBuilder.AppendLine("        }");
                }
                repositoriesStringBuilder.AppendLine("    }");
                repositoriesStringBuilder.AppendLine("}");
                var buildGradleSourceText = File.ReadAllText(buildGradlePath);//读取build.gradle内容
                var buildGradleText = buildGradleSourceText + repositoriesStringBuilder.ToString();
                File.WriteAllText(buildGradlePath, buildGradleText);//写回build.gradle
            }
        }
    }
}