﻿using System.Collections.Generic;
using System.IO;
using System.Text;
using UnityEditor.Android;
using UnityEngine;

namespace cn.m4399.sdk
{
    /// <summary>
    /// 生成Android项目时自定义dependencies
    /// 4399 sdk
    /// </summary>
    public abstract class AndroidGradleDependencies : IPostGenerateGradleAndroidProject
    {
        /// <summary>
        /// 顺序
        /// </summary>
        public virtual int callbackOrder => 4399;

        /// <summary>
        /// 子类复写这个方法返回依赖列表
        /// </summary>
        /// <returns></returns>
        public abstract List<string> Dependencies();

        public void OnPostGenerateGradleAndroidProject(string path)
        {
            var buildGradlePath = $"{path}/build.gradle";//build.gradle的路径
            Debug.Log($"buildGradlePath:{buildGradlePath}");

            var dependencies = Dependencies();
            if (dependencies != null && dependencies.Count > 0)
            {
                var dependenciesStringBuilder = new StringBuilder();
                dependenciesStringBuilder.AppendLine();
                dependenciesStringBuilder.AppendLine("dependencies {");
                //插入的dependencies内容
                foreach (var dependencie in dependencies)
                {
                    dependenciesStringBuilder.AppendLine($"    implementation '{dependencie}'");
                }
                dependenciesStringBuilder.AppendLine("}");
                var buildGradleSourceText = File.ReadAllText(buildGradlePath);//读取build.gradle内容
                var buildGradleText = buildGradleSourceText + dependenciesStringBuilder.ToString();
                File.WriteAllText(buildGradlePath, buildGradleText);//写回build.gradle
            }
        }
    }
}
