package cn.m4399.rpgsample;

import android.annotation.SuppressLint;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebViewClient;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import com.example.rpgsample.databinding.ActivityMainBinding;

import cn.m4399.operate.ExclusiveAgent;
import cn.m4399.operate.OperateCenter;
import cn.m4399.operate.OperateConfig;

public class RPGMakerActivity extends AppCompatActivity {

    private ActivityMainBinding mActivityMainBinding;

    /**
     * game key
     */
    private static final String GAME_KEY = "70001";

    /**
     * 屏幕方向
     */
    private static final int GAME_ORIENTATION = ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE;

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            getWindow().getDecorView().setSystemUiVisibility(
                    View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                            | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                            | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mActivityMainBinding = ActivityMainBinding.inflate(getLayoutInflater());
        setContentView(mActivityMainBinding.getRoot());
        loadGame();
        initSDK();
    }

    @Override
    public void onBackPressed() {
        OperateCenter.getInstance().shouldQuitGame(this, new OperateCenter.OnQuitGameListener() {
            @Override
            public void onQuitGame(boolean b) {
                if (b) {
                    finish();
                    System.exit(0);
                }
            }
        });
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void gameWebViewConf() {
        WebSettings webSettings = mActivityMainBinding.webView.getSettings();
        mActivityMainBinding.webView.setWebViewClient(new WebViewClient());
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAllowFileAccessFromFileURLs(true);
        webSettings.setDomStorageEnabled(true);
    }

    private void loadGame() {
        gameWebViewConf();
        mActivityMainBinding.webView.loadUrl("file:///android_asset/index.html");
    }

    private void initSDK() {
        // 配置全局属性，如横竖屏配置，完整的详细说明见接入文档
        OperateConfig operateConfig = new OperateConfig.Builder(this)
                // 设置调试模式，可选，true时打开，默认false,发布前必须设置为false或删除该行
                .setDebugEnabled(false)
                // 设置游戏运营 key，此参数需要在原创开放平台注册应用后得到
                .setGameKey(GAME_KEY)
                // 设置SDK页面方向，应与游戏方向一致，部分第三方页面需要在AndroidManifest中设置
                .setOrientation(GAME_ORIENTATION)
                .build();
        ExclusiveAgent.init(this, operateConfig, new ExclusiveAgent.OnInitGlobalListener() {

            @Override
            public void onInitFinished() {

            }
        });
    }

}