import { JavaClass } from "./reflect/JavaClass";
import { JavaObject } from "./reflect/JavaObject";

export class CocosAndroid {

    public static readonly JAVA_CLASS_NAME = "cn.m4399.sdk.cocos.CocosAndroid";

    public static getCocosActivity(): JavaObject {
        const javaClass = new JavaClass(CocosAndroid.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("getCocosActivity", [], []);
        javaClass.rm();
        return ret as JavaObject;
    }


    public static toast(msg: string): void {
        const javaClass = new JavaClass(CocosAndroid.JAVA_CLASS_NAME);
        javaClass.invokeStatic("toast", ["java.lang.String"], [msg]);
        javaClass.rm();
    }
}
