import { JavaClass } from "../sdk/cocos/reflect/JavaClass";
import { OpeResultListener, OpeResultListenerJavaProxy } from "./OpeResultListener";

/**
 * SDK 通用跳转
 */
export class OperateAction {
    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateAction";

    /**
     * 是否支持 key 的协议
     * @param key 
     * @param listener 
     */
    public static support(key: string, listener: OpeResultListener): void {
        const opeResultListenerJavaProxy = new OpeResultListenerJavaProxy(listener);
        const javaClass = new JavaClass(OperateAction.JAVA_CLASS_NAME);
        javaClass.invokeStatic("support", ["java.lang.String", OpeResultListenerJavaProxy.JAVA_CLASS_NAME], [key, opeResultListenerJavaProxy], true);
        javaClass.rm();
    }

    /**
     * 协议跳转
     * @param key 
     * @returns 
     */
    public static perform(key: string): number {
        const javaClass = new JavaClass(OperateAction.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("perform", ["java.lang.String"], [key], true) as number;
        javaClass.rm();
        return ret;
    }
}    