import { CocosAndroid } from "../sdk/cocos/CocosAndroid";
import { JavaClass } from "../sdk/cocos/reflect/JavaClass";
import { JavaProxy } from "../sdk/cocos/reflect/JavaProxy"
import { OperateConfig } from "./OperateConfig";
import { OpeResultListener, OpeResultListenerJavaProxy } from "./OpeResultListener";

export class ExclusiveAgent {

    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.ExclusiveAgent";

    /**
     * 初始化SDK
     * @param operateConfig 
     * @param onInitGlobalListener 
     */
    public static init(operateConfig: OperateConfig, onInitGlobalListener: ExclusiveAgent.OnInitGlobalListener): void {
        const onInitGlobalListenerJavaProxy = new OnInitGlobalListenerJavaProxy(onInitGlobalListener);
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const cocosActivity = CocosAndroid.getCocosActivity();
        javaClass.invokeStatic("init", ["android.app.Activity", OperateConfig.JAVA_CLASS_NAME, OnInitGlobalListenerJavaProxy.JAVA_CLASS_NAME], [cocosActivity, operateConfig.getJavaObject(), onInitGlobalListenerJavaProxy], true);
        cocosActivity.rm();
        javaClass.rm();
    }

    /**
     * 打开活动详情页
     * @param activityId 
     */
    public static openActivityDetailById(activityId: string): void {
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const cocosActivity = CocosAndroid.getCocosActivity();
        javaClass.invokeStatic("openActivityDetailById", ["android.app.Activity", "java.lang.String"], [cocosActivity, activityId], true);
        cocosActivity.rm();
        javaClass.rm();
    }

    /**
     * 使用活动码
     * @param activityId 
     * @param activityCode 
     * @param opeResultListener 
     */
    public static useActivityCode(activityId: string, activityCode: string, opeResultListener: OpeResultListener): void {
        const opeResultListenerJavaProxy = new OpeResultListenerJavaProxy(opeResultListener);
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        javaClass.invokeStatic("useActivityCode", ["java.lang.String", "java.lang.String", OpeResultListenerJavaProxy.JAVA_CLASS_NAME], [activityId, activityCode, opeResultListenerJavaProxy]);
        javaClass.rm();
    }

    /**
     * 打开礼包详情页
     * @param giftId 
     */
    public static openGiftDetailById(giftId: string): void {
        const cocosActivity = CocosAndroid.getCocosActivity();
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        javaClass.invokeStatic("openGiftDetailById", ["android.app.Activity", "java.lang.String"], [cocosActivity, giftId], true);
        cocosActivity.rm();
        javaClass.rm();
    }

    /**
     * 使用礼包码
     * @param giftId 
     * @param giftCode 
     * @param opeResultListener 
     */
    public static useGiftCode(giftId: string, giftCode: string, opeResultListener: OpeResultListener): void {
        const opeResultListenerJavaProxy = new OpeResultListenerJavaProxy(opeResultListener);
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        javaClass.invokeStatic("useGiftCode", ["java.lang.String", "java.lang.String", OpeResultListenerJavaProxy.JAVA_CLASS_NAME], [giftId, giftCode, opeResultListenerJavaProxy]);
        javaClass.rm();
    }

    /**
     * 打开游戏圈
     */
    public static openGameHub(): void {
        const cocosActivity = CocosAndroid.getCocosActivity();
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        javaClass.invokeStatic("openGameHub", ["android.app.Activity"], [cocosActivity], true);
        cocosActivity.rm();
        javaClass.rm();
    }

    /**
     * 礼包是否启用
     * @returns 
     */
    public static isGiftEnabled(): boolean {
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("isGiftEnabled", [], []);
        javaClass.rm();
        return ret as boolean;
    }

    /**
     * 是否有礼包
     * @returns 
     */
    public static isHasGift(): boolean {
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("isHasGift", [], []);
        javaClass.rm();
        return ret as boolean;
    }

    /**
     * 活动是否启用
     * @returns 
     */
    public static isActivityEnabled(): boolean {
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("isActivityEnabled", [], []);
        javaClass.rm();
        return ret as boolean;
    }

    /**
     * 是否有活动
     * @returns 
     */
    public static isHasActivity(): boolean {
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("isHasActivity", [], []);
        javaClass.rm();
        return ret as boolean;
    }

    /**
     * 游戏圈是否启用
     * @returns 
     */
    public static isGameHubEnabled(): boolean {
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("isGameHubEnabled", [], []);
        javaClass.rm();
        return ret as boolean;
    }

    /**
     * 打开游戏盒详情页
     */
    public static openGameDetail(): void {
        const javaClass = new JavaClass(ExclusiveAgent.JAVA_CLASS_NAME);
        const cocosActivity = CocosAndroid.getCocosActivity();
        javaClass.invokeStatic("openGameDetail", ["android.app.Activity"], [cocosActivity], true);
        cocosActivity.rm();
        javaClass.rm();
    }
}

class OnInitGlobalListenerJavaProxy extends JavaProxy {
    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.ExclusiveAgent$OnInitGlobalListener";

    private onInitGlobalListener: ExclusiveAgent.OnInitGlobalListener;

    constructor(onInitGlobalListener: ExclusiveAgent.OnInitGlobalListener) {
        super(OnInitGlobalListenerJavaProxy.JAVA_CLASS_NAME);
        this.onInitGlobalListener = onInitGlobalListener;
    }

    public onInitFinished(args: any[]): void {
        if (this.onInitGlobalListener) {
            this.onInitGlobalListener.onInitFinished();
        }
    }

    public onActivationState(args: any[]): void {
        if (this.onInitGlobalListener) {
            this.onInitGlobalListener.onActivationState(args[0] as number, args[1] as string);
        }
        this.rm();
    }
}

export namespace ExclusiveAgent {
    export interface OnInitGlobalListener {
        /**
         * 初始化完成
         */
        onInitFinished(): void;
        /**
         * 激活状态回调
         * @param code 
         * @param msg 
         */
        onActivationState(code: number, msg: string): void;
    }
}

