
export class JavaProxy {
    private readonly JAVA_PROXY_FACTORY_CLASS = "cn/m4399/sdk/cocos/reflect/JavaProxyFactory";
    private readonly JAVA_PROXY_CLASS = "cn/m4399/sdk/cocos/reflect/JavaProxy";

    private id: string;

    private objectId: string;

    public constructor(className: string) {
        this.id = JavaProxy.mount(this);
        const model = {
            "interfaceClass": className,
            "jsObject": `window.m4399.proxy["${this.id}"]`
        }
        this.objectId = jsb.reflection.callStaticMethod(this.JAVA_PROXY_FACTORY_CLASS, "createJavaProxy", "(Ljava/lang/String;)Ljava/lang/String;", JSON.stringify(model));   
       
    }

    public rm(): void {
        jsb.reflection.callStaticMethod(this.JAVA_PROXY_CLASS, "rm", "(Ljava/lang/String;)V", this.objectId);
        JavaProxy.unmount(this.id);
    }

    private static genID() {
        return `t${new Date().getTime()}r${Math.random().toString().substring(2)}`;
    }

    private static mount(obj: any): string {
        const mount = window as any;
        if (!mount.m4399) {
            mount.m4399 = {};
        }
        if (!mount.m4399.proxy) {
            mount.m4399.proxy = [];
        }
        
        const id: string = JavaProxy.genID();
        mount.m4399.proxy[id] = obj;
        return id;
    }

    private static unmount(id: string): void {
        const mount = window as any;
        mount.m4399.proxy[id] = undefined;
    }

}

