import { JavaClass } from "./JavaClass";
import { RetParser } from "./tool/RetParser";
export class JavaObject {

    private static readonly JAVA_OBJECT_FACTORY_CLASS = "cn/m4399/sdk/cocos/reflect/JavaObjectFactory";
    private static readonly JAVA_OBJECT_CLASS = "cn/m4399/sdk/cocos/reflect/JavaObject"

    public javaClass: JavaClass;
    public objectId: string;

    public constructor(className: string, objectId: string) {
        this.javaClass = new JavaClass(className);
        this.objectId = objectId;
    }

    public static newInstance(className: string, argClasses: string[], args: any[]): JavaObject {
        const model = {
            "className": className,
            "methodName": "<init>",
            "argClasses": argClasses,
            "args": args,
        }
        const objectId = jsb.reflection.callStaticMethod(JavaObject.JAVA_OBJECT_FACTORY_CLASS, "createJavaObject", "(Ljava/lang/String;)Ljava/lang/String;", JSON.stringify(model));
        return new JavaObject(className, objectId);
    }

    public static fromInstance(instance: any): JavaObject {
        return new JavaObject(instance.className, instance.objectId);
    }


    public invokeStatic(methodName: string, argClasses: string[], args: any[]): any {
        return this.javaClass.invokeStatic(methodName, argClasses, args);
    }

    public setStatic(fieldName: string, value: any): void {
        this.javaClass.setStatic(fieldName, value);
    }

    public getStatic(fieldName: string): any {
        return this.javaClass.getStatic(fieldName);
    }

    public invoke(methodName: string, argClasses: string[], args: any[], uiThread: boolean = false): any {
        const invokeModel = {
            "methodName": methodName,
            "argClasses": argClasses,
            "args": args,
            "uiThread": uiThread
        };
        const json = jsb.reflection.callStaticMethod(JavaObject.JAVA_OBJECT_CLASS, 'invoke', '(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;', this.objectId, JSON.stringify(invokeModel));
        return RetParser.parseRet(json);
    }

    public set(fieldName: string, value: any): void {
        const setModel = {
            "fieldName": fieldName,
            "value": value
        }
        jsb.reflection.callStaticMethod(JavaObject.JAVA_OBJECT_CLASS, "set", "(Ljava/lang/String;Ljava/lang/String;)V", this.objectId, JSON.stringify(setModel));
    }

    public get(fieldName: string): any {
        const getModel = {
            "fieldName": fieldName,
        }
        const json = jsb.reflection.callStaticMethod(JavaObject.JAVA_OBJECT_CLASS, "get", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", this.objectId, JSON.stringify(getModel));
        return RetParser.parseRet(json);
    }

    public rm(): void {
        this.javaClass.rm();
        jsb.reflection.callStaticMethod(JavaObject.JAVA_OBJECT_CLASS, "rm", "(Ljava/lang/String;)V", this.objectId);
    }
}

