import { RetParser } from "./tool/RetParser";

export class JavaClass {

    private static readonly JAVA_CLASS_FACTORY_CLASS = "cn/m4399/sdk/cocos/reflect/JavaClassFactory";
    private static readonly JAVA_CLASS_CLASS = "cn/m4399/sdk/cocos/reflect/JavaClass";

    private objectId: string;

    public constructor(className: string) {
        const model = {
            "className": className
        }
        this.objectId = jsb.reflection.callStaticMethod(JavaClass.JAVA_CLASS_FACTORY_CLASS, "createJavaClass", "(Ljava/lang/String;)Ljava/lang/String;", JSON.stringify(model));
    }


    public invokeStatic(methodName: string, argClasses: string[], args: any[], uiThread: boolean = false): any {
        const invokeModel = {
            "methodName": methodName,
            "argClasses": argClasses,
            "args": args,
            "uiThread": uiThread
        };
        const json = jsb.reflection.callStaticMethod(JavaClass.JAVA_CLASS_CLASS, "invokeStatic", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", this.objectId, JSON.stringify(invokeModel));
        return RetParser.parseRet(json);
    }

    public setStatic(fieldName: string, value: any): void {
        const setModel = {
            "fieldName": fieldName,
            "value": value
        }
        jsb.reflection.callStaticMethod(JavaClass.JAVA_CLASS_CLASS, "setStatic", "(Ljava/lang/String;Ljava/lang/String;)V", this.objectId, JSON.stringify(setModel));
    }

    public getStatic(fieldName: string): any {
        const getModel = {
            "fieldName": fieldName,
        }
        const json = jsb.reflection.callStaticMethod(JavaClass.JAVA_CLASS_CLASS, "getStatic", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", this.objectId, JSON.stringify(getModel));
        return RetParser.parseRet(json);
    }

    public rm(): void {
        jsb.reflection.callStaticMethod(JavaClass.JAVA_CLASS_CLASS, "rm", "(Ljava/lang/String;)V", this.objectId);
    }
}
