import { JavaClass } from "./reflect/JavaClass";
import { JavaProxy } from "./reflect/JavaProxy";

export interface OnRequestPermissionResultListener {
    (requestCode: number, permission: string, grantResult: boolean);
}
class OnRequestPermissionsResultListenerJavaProxy extends JavaProxy {
    public static readonly JAVA_CLASS_NAME = "cn.m4399.sdk.cocos.PermissionHelper$OnRequestPermissionResultListener";
    private onRequestPermissionResultListener: OnRequestPermissionResultListener;
    constructor(onRequestPermissionResultListener: OnRequestPermissionResultListener) {
        super(OnRequestPermissionsResultListenerJavaProxy.JAVA_CLASS_NAME);
        this.onRequestPermissionResultListener = onRequestPermissionResultListener;
    }

    public onRequestPermissionResult(args: any[]) {
        if (this.onRequestPermissionResultListener) {
            const requestCode = args[0] as number;
            const permission = args[1] as string;
            const grantResult = args[2] as boolean;
            this.onRequestPermissionResultListener(requestCode, permission, grantResult);
        }
        this.rm();
    }
}
export class PermissionHelper {

    public static readonly JAVA_CLASS_NAME = "cn.m4399.sdk.cocos.PermissionHelper";

    public static readonly WRITE_EXTERNAL_STORAGE = "android.permission.WRITE_EXTERNAL_STORAGE";

    public static checkSelfPermission(permission: string): boolean {
        const javaClass = new JavaClass(PermissionHelper.JAVA_CLASS_NAME);
        const ret = javaClass.invokeStatic("checkSelfPermission", ["java.lang.String"], [permission]) as boolean;
        javaClass.rm();
        return ret;
    }

    public static requestPermission(requestCode: number, permission: string, onRequestPermissionResultListener: OnRequestPermissionResultListener = null): void {
        try {
            const javaClass = new JavaClass(PermissionHelper.JAVA_CLASS_NAME);
            if (onRequestPermissionResultListener) {
                const onRequestPermissionsResultListenerJavaProxy = new OnRequestPermissionsResultListenerJavaProxy(onRequestPermissionResultListener);
                javaClass.invokeStatic("requestPermission", ["int", "java.lang.String", OnRequestPermissionsResultListenerJavaProxy.JAVA_CLASS_NAME], [requestCode, permission, onRequestPermissionsResultListenerJavaProxy], true);
            } else {
                javaClass.invokeStatic("requestPermission", ["int", "java.lang.String"], [requestCode, permission], true);
            }
            javaClass.rm();
        } catch(e) {
            console.log(e)
        }
        
    }
}