import { JavaObject } from "../sdk/cocos/reflect/JavaObject";
import { JavaClass } from "../sdk/cocos/reflect/JavaClass";
import { JavaProxy } from "../sdk/cocos/reflect/JavaProxy";

export class User {

    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.User";
    private javaObject: JavaObject;
    

    constructor(javaObjct: JavaObject) {
        this.javaObject = javaObjct;
    }


     /**
     * uid
     */
    public getUid(): String {
        return this.javaObject.invoke("getUid", [], []);
    }

    /**
     * 用户名
     */
    public getName(): String {
        return this.javaObject.invoke("getName", [], []);
    }

    /**
     * 昵称
     */
    public getNick(): String {
        return this.javaObject.invoke("getNick", [], []);
    }

    /**
     * 登录状态
     */
    public getState(): string {
        return this.javaObject.invoke("getState", [], []);
    }

    /**
     * 绑定的手机号，已脱敏，若已绑定则此字段非空
     */
    public getPhone(): String {
        return this.javaObject.invoke("getPhone", [], []);
    }

    /**
     * 获取实名状态
     *
     * @return v2.30.0.28及之前版本， 0 未实名，1 小于8岁，2 小于18岁，3、4 18岁及以上;
     * v2.30.0.28之后版本， 0 未实名，1 小于8岁，2 8-15岁，3、4 18岁及以上，5 16-17岁;
     * 其他值无效
     */
    public getIdCardState(): number {
        return this.javaObject.invoke("getIdCardState", [], []);
    }

    /**
     * 是否通过实名认证
     *
     * @return true:通过（身份信息可能是未成年人），false：不通过
     * @deprecated
     */
    public isIdCheckedReal(): boolean {
        return this.javaObject.invoke("isIdCheckedReal", [], []);
    }

    /**
     * 控制游戏中“实名认证”UI显示/隐藏
     *
     * @return true:可调用实名认证接口，false：不可调用
     * @deprecated
     */
    public isIdCardEditable(): boolean {
        return this.javaObject.invoke("isIdCardEditable", [], []);
    }

    public toString():string {
        return "User: [" + this.getUid() + "," + this.getName() + ", " + this.getNick() + ", " + this.getState() + "]";
    }

}