import { CocosAndroid } from "../sdk/cocos/CocosAndroid";
import { JavaClass } from "../sdk/cocos/reflect/JavaClass";
import { JavaObject } from "../sdk/cocos/reflect/JavaObject";

export class OperateConfig {

    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateConfig";

    private javaObject: JavaObject;

    constructor(javaObject: JavaObject) {
        this.javaObject = javaObject;
    }

    getJavaObject() {
        return this.javaObject;
    }

    public rm() {
        this.javaObject.rm();
    }

}

export namespace OperateConfig {
    export enum PopWinPosition {
        POS_LEFT = "POS_LEFT",
        POS_BOTTOM = "POS_BOTTOM",
        POS_RIGHT = "POS_RIGHT",
        POS_TOP = "POS_TOP"
    }

    export enum PopLogoStyle {
        POPLOGOSTYLE_ONE = "POPLOGOSTYLE_ONE",
        POPLOGOSTYLE_TWO = "POPLOGOSTYLE_TWO",
        POPLOGOSTYLE_THREE = "POPLOGOSTYLE_THREE",
        POPLOGOSTYLE_FOUR = "POPLOGOSTYLE_FOUR"
    }

    export class Builder {
        public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateConfig$Builder";
        private javaObject: JavaObject;
        constructor() {
            const cocosActivity = CocosAndroid.getCocosActivity();
            this.javaObject = JavaObject.newInstance(Builder.JAVA_CLASS_NAME, ["android.content.Context"], [cocosActivity]);
            cocosActivity.rm();
        }

        public setDebugEnabled(enabled: boolean): Builder {
            const javaObject = this.javaObject.invoke("setDebugEnabled", ["boolean"], [enabled]) as JavaObject;
            javaObject.rm();
            return this;
        }

        public setOrientation(orientation: number): Builder {
            const javaObject = this.javaObject.invoke("setOrientation", ["int"], [orientation]) as JavaObject;
            javaObject.rm();
            return this;
        }

        public setLoginOrientation(orientation: number): Builder {
            const javaObject = this.javaObject.invoke("setLoginOrientation", ["int"], [orientation]) as JavaObject;
            javaObject.rm();
            return this;
        }

        public setSupportExcess(supportExcess: boolean): Builder {
            const javaObject = this.javaObject.invoke("setSupportExcess", ["boolean"], [supportExcess]) as JavaObject;
            javaObject.rm();
            return this;
        }

        public setPopLogoStyle(style: OperateConfig.PopLogoStyle): Builder {
            const popLogoStyleJavaClassName = "cn.m4399.operate.OperateConfig$PopLogoStyle";
            const popLogoStyleJavaClass = new JavaClass(popLogoStyleJavaClassName);
            const styleJavaObject = popLogoStyleJavaClass.getStatic(style.toString()) as JavaObject;
            const retJavaObject = this.javaObject.invoke("setPopLogoStyle", [popLogoStyleJavaClassName], [styleJavaObject]) as JavaObject;
            retJavaObject.rm();
            styleJavaObject.rm();
            popLogoStyleJavaClass.rm();
            return this;
        }

        public setGameKey(gameKey: string): Builder {
            const javaObject = this.javaObject.invoke("setGameKey", ["java.lang.String"], [gameKey]) as JavaObject;
            javaObject.rm();
            return this;
        }

        public setPopWinPosition(popWinPosition: OperateConfig.PopWinPosition): Builder {
            const popWinPositionJavaClassName = "cn.m4399.operate.OperateConfig$PopWinPosition";
            const popWinPositionJavaClass = new JavaClass(popWinPositionJavaClassName);
            const positionJavaObject = popWinPositionJavaClass.getStatic(popWinPosition.toString()) as JavaObject;
            const retJavaObject = this.javaObject.invoke("setPopWinPosition", [popWinPositionJavaClassName], [positionJavaObject]) as JavaObject;
            retJavaObject.rm();
            positionJavaObject.rm();
            popWinPositionJavaClass.rm();
            return this;
        }

        public setSMEnable(smEnable: boolean): Builder {
            const javaObject = this.javaObject.invoke("setSMEnable", ["boolean"], [smEnable]) as JavaObject;
            javaObject.rm();
            return this;
        }

        public compatNotch(compat: boolean): Builder {
            const javaObject = this.javaObject.invoke("compatNotch", ["boolean"], [compat]) as JavaObject;
            javaObject.rm();
            return this;
        }

        public build(): OperateConfig {
            const javaObject = this.javaObject.invoke("build", [], []) as JavaObject;
            return new OperateConfig(javaObject);
        }

        public rm() {
            this.javaObject.rm();
        }
    }
}