import { CocosAndroid } from "../sdk/cocos/CocosAndroid";
import { JavaClass } from "../sdk/cocos/reflect/JavaClass";
import { JavaObject } from "../sdk/cocos/reflect/JavaObject";
import { JavaProxy } from "../sdk/cocos/reflect/JavaProxy";
import { OperateConfig } from "./OperateConfig";
import { User } from "./User";

export class OperateCenter {

    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateCenter";

    private javaObject: JavaObject;

    

    constructor(javaObject: JavaObject) {
        this.javaObject = javaObject;
    }

    /**
     * 获取运营SDK实例
     * @returns 
     */
    public static getInstance(): OperateCenter {
        const javaClass = new JavaClass(OperateCenter.JAVA_CLASS_NAME);
        const javaObject = javaClass.invokeStatic("getInstance", [], []);
        javaClass.rm();
        return new OperateCenter(javaObject);
    }

    /**
     * 初始化
     * @param onInitGlobalListener 
     */
    public init(onInitGlobalListener: OperateCenter.OnInitGlobalListener): void {
        const onInitGlobalListenerJavaProxy = new OnInitGlobalListenerJavaProxy(onInitGlobalListener);
        const cocosActivity = CocosAndroid.getCocosActivity();
        this.javaObject.invoke("init", ["android.app.Activity", OnInitGlobalListenerJavaProxy.JAVA_CLASS_NAME], [cocosActivity, onInitGlobalListenerJavaProxy], true);
        cocosActivity.rm();
    }
    

    /**
     * 登录
     * @param listener 
     */
    public login(listener: OperateCenter.OnLoginFinishedListener):void {
        const OnLoginFinishedListenerJavaProxy = new OperateCenter.OnLoginFinishedListenerJavaProxy(listener);
        const cocosActivity = CocosAndroid.getCocosActivity();
        this.javaObject.invoke("login", ["android.app.Activity", OperateCenter.OnLoginFinishedListenerJavaProxy.JAVA_CLASS_NAME], [cocosActivity, OnLoginFinishedListenerJavaProxy], true)
        cocosActivity.rm();
    }

    /**
     * 充值
     * @param money 
     * @param mark 
     * @param commodity 
     * @param listener 
     */
     public recharge(money: number, mark: String, commodity: String, listener: OperateCenter.OnRechargeFinishedListener) {
        const OnRechargeFinishedListenerJavaProxy = new OperateCenter.OnRechargeFinishedListenerJavaProxy(listener);
        const cocosActivity = CocosAndroid.getCocosActivity();
        this.javaObject.invoke("recharge", ["android.app.Activity", "int", "java.lang.String", "java.lang.String", OperateCenter.OnRechargeFinishedListenerJavaProxy.JAVA_CLASS_NAME], [cocosActivity, money, mark, commodity, OnRechargeFinishedListenerJavaProxy], true);
        cocosActivity.rm;

    }


    /**
     * 切换用户
     * @param listener 
     */
     public switchAccount(listener: OperateCenter.OnLoginFinishedListener):void {
        const OnLoginFinishedListenerJavaProxy = new OperateCenter.OnLoginFinishedListenerJavaProxy(listener);
        const cocosActivity = CocosAndroid.getCocosActivity();
        this.javaObject.invoke("switchAccount", ["android.app.Activity", OperateCenter.OnLoginFinishedListenerJavaProxy.JAVA_CLASS_NAME], [cocosActivity, OnLoginFinishedListenerJavaProxy], true)
        cocosActivity.rm();
    }

    /**
     * Description: 获取当前账户信息
     *
     * @return 当前账户信息
     */
     public getCurrentAccount(): User {
        return new User(this.javaObject.invoke("getCurrentAccount", [], []));
    }


    /**
     * Description: 注销
     */
     public logout(): void {
        this.javaObject.invoke("logout", [], []);
    }

    
    /**
     * Description: 设置服务器ID
     *
     * @param serverStr 服务器ID
     */
     public setServer(serverStr: string): void {
         this.javaObject.invoke("setServer", ["java.lang.String"], [serverStr]);
    }


    /**
     * 退出游戏
     * @param onQuitGameListener 
     */
    public shouldQuitGame(onQuitGameListener: OperateCenter.OnQuitGameListener): void {
        const onQuitGameListenerJavaProxy = new OperateCenter.OnQuitGameListenerJavaProxy(onQuitGameListener);
        const cocosActivity = CocosAndroid.getCocosActivity();
        this.javaObject.invoke("shouldQuitGame", ["android.app.Activity", OperateCenter.OnQuitGameListenerJavaProxy.JAVA_CLASS_NAME], [cocosActivity, onQuitGameListenerJavaProxy], true);
        cocosActivity.rm();
    }

    /**
     * 配置SDK
     * @param config 
     */
    public setConfig(config: OperateConfig): void {
        this.javaObject.invoke("setConfig", [OperateConfig.JAVA_CLASS_NAME], [config.getJavaObject()], true);
    }

    public rm() {
        this.javaObject.rm();
    }

    
}


class OnInitGlobalListenerJavaProxy extends JavaProxy {
    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateCenter$OnInitGlobalListener";

    private onInitGlobalListener: OperateCenter.OnInitGlobalListener;


    constructor(onInitGlobalListener: OperateCenter.OnInitGlobalListener) {
        super(OnInitGlobalListenerJavaProxy.JAVA_CLASS_NAME);
        this.onInitGlobalListener = onInitGlobalListener;
    }

    public onInitFinished(args: any[]): void {
        if (this.onInitGlobalListener) {
            this.onInitGlobalListener.onInitFinished();
        }
    }

    public onUserAccountLogout(fromUserCenter: boolean): void {
        if (this.onInitGlobalListener) {
            this.onInitGlobalListener.onUserAccountLogout(fromUserCenter);
        }
    }

    public onSwitchUserAccountFinished(args: any[]) {
        if (this.onInitGlobalListener) {
            const javaObjct = JavaObject.fromInstance(args[1]) as JavaObject;
            this.onInitGlobalListener.onSwitchUserAccountFinished(args[0] as boolean, new User(javaObjct));
        }
    }
}

export namespace OperateCenter {

    export interface OnQuitGameListener {
        (shouldQuit: boolean): void;
    }

    export interface OnInitGlobalListener {
        /**
         * 初始化完成
         */
        onInitFinished(): void;

         /**
         * Description: 用户注销的回调，包括在个人中心中的注销，和调用logout（）的注销
         *
         * @param fromUserCenter 是否是用户中心里注销
         */
          onUserAccountLogout(fromUserCenter: boolean): void;

          /**
           * Description: 设置切换用户（个人中心）监听器
           *
           * @param user 用户信息
           */
          onSwitchUserAccountFinished(fromUserCenter: boolean, user: User): void;
    }

    export interface OnLoginFinishedListener {
        (success: boolean, resultCode: number, user: User): void;
    }

    export class OnLoginFinishedListenerJavaProxy extends JavaProxy {
        public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateCenter$OnLoginFinishedListener";
        private onLoginFinishedListener: OnLoginFinishedListener;
        public constructor(onLoginFinishedListener: OnLoginFinishedListener) {
            super(OnLoginFinishedListenerJavaProxy.JAVA_CLASS_NAME);
            this.onLoginFinishedListener = onLoginFinishedListener;
        }

        public onLoginFinished(args: any[]): void {
            if (this.onLoginFinishedListener) {
                console.log(`1111111111111111 ${JSON.stringify(args[2])}`)
                const javaObjct = JavaObject.fromInstance(args[2]) as JavaObject;
                console.log(`1111111111111111 ${JSON.stringify(javaObjct)}`)
                console.log(`1111111111111111 ${JSON.stringify(new User(javaObjct))}`)
                this.onLoginFinishedListener(args[0] as boolean, args[1] as number, new User(javaObjct));
                javaObjct.rm;
            }
            this.rm();
        }
    }

    export interface OnRechargeFinishedListener {
        (success: boolean, resultCode: number, msg: String): void;
    }

    export class OnRechargeFinishedListenerJavaProxy extends JavaProxy {
        public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateCenter$OnRechargeFinishedListener";
        private onRechargeFinishedListener: OnRechargeFinishedListener;
        public constructor(onRechargeFinishedListener: OnRechargeFinishedListener) {
            super(OnRechargeFinishedListenerJavaProxy.JAVA_CLASS_NAME);
            this.onRechargeFinishedListener = onRechargeFinishedListener;
        }

        public onRechargeFinished(args: any[]): void {
            if (this.onRechargeFinishedListener) {
                this.onRechargeFinishedListener(args[0] as boolean, args[1] as number, args[2] as String);
            }
            this.rm();
        }
    }

    export class OnQuitGameListenerJavaProxy extends JavaProxy {
        public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OperateCenter$OnQuitGameListener";
        private onQuitGameListener: OnQuitGameListener;
        public constructor(onQuitGameListener: OnQuitGameListener) {
            super(OnQuitGameListenerJavaProxy.JAVA_CLASS_NAME);
            this.onQuitGameListener = onQuitGameListener;
        }

        public onQuitGame(args: any[]): void {
            if (this.onQuitGameListener) {
                this.onQuitGameListener(args[0] as boolean);
            }
            this.rm();
        }
    }
}