import { JavaProxy } from "../sdk/cocos/reflect/JavaProxy"

export interface OpeResultListener {
    (code: number, message: string): void;
}

export class OpeResultListenerJavaProxy extends JavaProxy {
    public static readonly JAVA_CLASS_NAME = "cn.m4399.operate.OpeResultListener";
    private opeResultListener: OpeResultListener;

    public constructor(opeResultListener: OpeResultListener) {
        super(OpeResultListenerJavaProxy.JAVA_CLASS_NAME);
        this.opeResultListener = opeResultListener;
    }

    public onResult(args: any[]): void {
        if (this.opeResultListener) {
            this.opeResultListener(args[0] as number, args[1] as string);
        }
        this.rm();
    }
}
