import { _decorator, Component, EditBox, Button, input, Input, EventKeyboard, KeyCode, game} from 'cc';
const { ccclass, property } = _decorator;

import { ExclusiveAgent } from "./cn/m4399/operate/ExclusiveAgent";
import { OperateAction } from "./cn/m4399/operate/OperateAction";
import { OperateCenter } from "./cn/m4399/operate/OperateCenter";
import { OperateConfig } from "./cn/m4399/operate/OperateConfig";
import { CocosAndroid } from "./cn/m4399/sdk/cocos/CocosAndroid";
import { PermissionHelper } from "./cn/m4399/sdk/cocos/PermissionHelper";

@ccclass('EaCocosDemo')
export default class EaCocosDemo extends Component {
    @property(EditBox)
    edtActivityDetailKey: EditBox;
    @property(Button)
    btnOpenActivityDetail: Button;
    @property(EditBox)
    edtUseActivityId: EditBox;
    @property(EditBox)
    edtUseActivityCode: EditBox;
    @property(Button)
    btnUseActivityCode: Button;
    @property(EditBox)
    edtGiftDetailKey: EditBox;
    @property(Button)
    btnOpenGiftDetail: Button;
    @property(EditBox)
    edtUseGiftId: EditBox;
    @property(EditBox)
    edtUseGiftCode: EditBox;
    @property(Button)
    btnUseGiftCode: Button;
    @property(Button)
    btnGameHub: Button;
    @property(Button)
    btnGameDetail: Button;
    @property(EditBox)
    edtOperateActionKey: EditBox;
    @property(Button)
    btnOperateAction: Button;
    private static readonly TAG = "【EaCocosDemo】";
    private static readonly GAME_KEY = "70001";
    private requestedPermission = false;
    onLoad() {
        this.btnOpenActivityDetail.node.on("click", () => {
        this.doOpenActivityDetail();
        });
        this.btnUseActivityCode.node.on("click", () => {
        this.doUseActivityCode();
        });
        this.btnOpenGiftDetail.node.on("click", () => {
        this.doOpenGiftDetail();
        });
        this.btnUseGiftCode.node.on("click", () => {
        this.doUseGiftCode();
        });
        this.btnGameHub.node.on("click", () => {
        this.doOpenGameHub();
        });
        this.btnGameDetail.node.on("click", () => {
        this.doOpenGameDetail();
        });
        this.btnOperateAction.node.on("click", () => {
        this.doOperateAction();
        })
        this.initEaSDK();
        this.edtActivityDetailKey.blur();
        this.edtUseActivityId.blur();
        this.edtUseActivityCode.blur();
        this.edtGiftDetailKey.blur();
        this.edtUseGiftId.blur();
        this.edtUseGiftCode.blur();
        this.edtOperateActionKey.blur();

        input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
    }
    start() {

    }

    public initEaSDK(): void {
        if (this.requestedPermission || PermissionHelper.checkSelfPermission(PermissionHelper.WRITE_EXTERNAL_STORAGE)) {
            const operateConfigBuilder = new OperateConfig.Builder();
            operateConfigBuilder.setDebugEnabled(true)
                .setGameKey(EaCocosDemo.GAME_KEY)
                .setOrientation(0)
                .setLoginOrientation(0)
                .setSupportExcess(false)
                .setSMEnable(false)
                .setPopLogoStyle(OperateConfig.PopLogoStyle.POPLOGOSTYLE_ONE)
                .setPopWinPosition(OperateConfig.PopWinPosition.POS_TOP)
                .compatNotch(true);
            const operateConfig = operateConfigBuilder.build();
            const that = this;
            ExclusiveAgent.init(operateConfig, {
                onInitFinished() {
                    CocosAndroid.toast("初始化完成");
                },
                onActivationState(code: number, msg: string) {
                    CocosAndroid.toast(`激活状态回调:${code}, ${msg}`);
                }
            });
            operateConfig.rm();
            operateConfigBuilder.rm();
        } else {
            this.requestedPermission = true;
            CocosAndroid.toast("请授予权限!");
            PermissionHelper.requestPermission(0, PermissionHelper.WRITE_EXTERNAL_STORAGE, (requestCode, permission, grantResult) => {
                this.initEaSDK();
            });
        }
    }
    public doOpenActivityDetail() {
        const activityDetailKey = this.edtActivityDetailKey.string;
        this.action(activityDetailKey);
    }
    public doUseActivityCode() {
        const activityId = this.edtUseActivityId.string;
        const activityCode = this.edtUseActivityCode.string;
        ExclusiveAgent.useActivityCode(activityId, activityCode, (code, message) => {
        this.logAndToast(`${code} : ${message}`);
        });
    }
    public doOpenGiftDetail() {
        const giftDetailKey = this.edtGiftDetailKey.string;
        this.action(giftDetailKey);
    }
    public doUseGiftCode() {
        const giftId = this.edtUseGiftId.string;
        const giftCode = this.edtUseGiftCode.string;
        ExclusiveAgent.useGiftCode(giftId, giftCode, (code, message) => {
        this.logAndToast(`${code} : ${message}`);
        });
    }
    public doOpenGameHub() {
        const gameHubKey = "51nfesTWNwVSYhXfxd1";
        this.action(gameHubKey);
    }
    public doOpenGameDetail() {
        const gameDetailKey = "51nnEXdiUzpcsmbdgH2";
        this.action(gameDetailKey);
    }
    public doOperateAction() {
        const key = this.edtOperateActionKey.string;
        this.action(key);
    }
    public action(key: string) {
        OperateAction.support(key, (code, message) => {
        const ret = OperateAction.perform(key);
        this.logAndToast(`${ret} : ${message}`);
        });
    }
    public logAndToast(msg: string) {
        const str = `${EaCocosDemo.TAG} ${msg}`;
        console.log(str);
        CocosAndroid.toast(str);
    }
    
    onKeyDown(event: EventKeyboard){
        if (event.keyCode === KeyCode.MOBILE_BACK) {
            const operateCenter = OperateCenter.getInstance();
            operateCenter.shouldQuitGame((shouldQuit) => {
                if (shouldQuit) {
                    game.end();
                }
            });
        }
    }
}

